------------------------------------------------------------------------------
--	FILE:	 GiantEarth.Lua
--  Convertion of Civ IV Genghis Kai's GEM (using Hornigas version for Civ V - BNW)
--  Imported to Civ VI by Gedemon (2016)
------------------------------------------------------------------------------

include "MapEnums"
include "MapUtilities"
include "MountainsCliffs"
include "RiversLakes"
include "FeatureGenerator"
include "TerrainGenerator"
include "NaturalWonderGenerator"
include "ResourceGenerator"
include "AssignStartingPlots"

local mapName = MapConfiguration.GetValue("MapName")
print("Loading "..tostring(mapName).." script")

local g_iW = 180
local g_iH = 94
local g_iFlags = {}
local g_continentsFrac = nil

------------------------------------------------------------------------------
-- The application side will call GetMapScriptInfo directly to request
-- information about the map script.
-------------------------------------------------------------------------------
function GetMapInitData(worldSize)
	return {
		Width = g_iW,
		Height = g_iH,
		WrapX = true,
		WrapY = false,
	};      
end


-------------------------------------------------------------------------------
function GenerateMap()
	print("Calling Map Generator");
	GenerateImportedMap(GetMap(), GetCiv6DataToConvert(), GetNaturalWonders(), g_iW, g_iH)
end

function GetNaturalWonders()
	local NaturalWonders = {}
	NaturalWonders[6]  = { X = 101, Y = 23} -- FEATURE_BARRIER_REEF
	NaturalWonders[7]  = { X = 11, Y = 71} 	-- FEATURE_CLIFFS_DOVER
	NaturalWonders[8]  = { X = 132, Y = 65} -- FEATURE_CRATER_LAKE
	NaturalWonders[9]  = { X = 37, Y = 50} 	-- FEATURE_DEAD_SEA
	NaturalWonders[10] = { X = 64, Y = 54} 	-- FEATURE_EVEREST
	NaturalWonders[11] = { X = 144, Y = 35} -- FEATURE_GALAPAGOS
	NaturalWonders[12] = { X = 31, Y = 27} 	-- FEATURE_KILIMANJARO
	NaturalWonders[13] = { X = 159, Y = 27} -- FEATURE_PANTANAL
	NaturalWonders[14] = { X = 107, Y = 3} 	-- FEATURE_PIOPIOTAHI
	NaturalWonders[15] = { X = 154, Y = 7} 	-- FEATURE_TORRES_DEL_PAINE
	NaturalWonders[16] = { X = 36, Y = 18} 	-- FEATURE_TSINGY
	NaturalWonders[17] = { X = 132, Y = 62} -- FEATURE_YOSEMITE
	
	return NaturalWonders
end

function GetCiv6DataToConvert()
	local Civ6DataToConvert = {}
	for i = 0, g_iW - 1, 1 do
		Civ6DataToConvert[i] = {}
	end
	
	-- Civ6 Data
	-- Civ6DataToConvert[x][y]={{IsNEOfCliff,IsWOfCliff,IsNWOfCliff},}
	Civ6DataToConvert[6][70]={{0,1,0},}
	Civ6DataToConvert[7][70]={{1,0,1},}
	Civ6DataToConvert[6][71]={{0,0,1},}
	Civ6DataToConvert[9][71]={{0,0,1},}
	Civ6DataToConvert[10][71]={{1,0,0},}
	Civ6DataToConvert[12][71]={{0,1,1},}
	Civ6DataToConvert[7][73]={{0,0,1},}
	Civ6DataToConvert[7][74]={{0,1,1},}
	Civ6DataToConvert[9][77]={{1,0,0},}
	Civ6DataToConvert[10][77]={{0,1,0},}
	Civ6DataToConvert[8][78]={{1,0,1},}
	Civ6DataToConvert[11][78]={{1,0,0},}
	Civ6DataToConvert[7][79]={{0,1,1},}
	Civ6DataToConvert[6][80]={{0,1,0},}
	Civ6DataToConvert[10][80]={{0,1,0},}
	Civ6DataToConvert[10][81]={{0,1,1},}
	Civ6DataToConvert[7][82]={{0,1,1},}
	Civ6DataToConvert[7][83]={{0,1,1},}
	Civ6DataToConvert[9][83]={{0,1,0},}
	Civ6DataToConvert[11][84]={{0,1,0},}
	Civ6DataToConvert[12][84]={{1,0,1},}
	
	return Civ6DataToConvert
end

function GetMap()

	local MapToConvert = {}
	for i = 0, g_iW - 1, 1 do
		MapToConvert[i] = {}
	end
	
	-- Map Data
	-- MapToConvert[x][y] = {civ5TerrainType, civ5PlotTypes, civ5FeatureTypes, civ5ContinentType, {{IsNEOfRiver, flow}, {IsWOfRiver, flow}, {IsNWOfRiver, flow}}, {Civ5ResourceType, num} }
	
 MapToConvert[0][0]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][0]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][0]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][0]={4,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][0]={5,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][0]={4,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][0]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][0]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][0]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][0]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][0]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][0]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][0]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][0]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][0]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][0]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][0]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][0]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][0]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][0]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][0]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][0]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][0]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][0]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][0]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][0]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][0]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][0]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][0]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][0]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][0]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][0]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][0]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][0]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][0]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][0]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][0]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][0]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][0]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][0]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][0]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][0]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][0]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][0]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][0]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][0]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][0]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][0]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][0]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][0]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][0]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][1]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][1]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][1]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][1]={4,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][1]={4,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][1]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][1]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][1]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][1]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][1]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][1]={4,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][1]={4,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][1]={4,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][1]={4,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][1]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][1]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][1]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][1]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][1]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][1]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][1]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][1]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][1]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][1]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][1]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][1]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][1]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][1]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][1]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][1]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][1]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][1]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][1]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][1]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][1]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][1]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][1]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][1]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][1]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][1]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][1]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][1]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][1]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][1]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][1]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][1]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][1]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[106][1]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][1]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][1]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][1]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][1]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][1]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][1]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][1]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][1]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][1]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][1]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][1]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][1]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][1]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][1]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][1]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][1]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][1]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][1]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][1]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][1]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][1]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][1]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][1]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][1]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][1]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][1]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][1]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][1]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][1]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][1]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][1]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][1]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][1]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][1]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][1]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][1]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][1]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][1]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][1]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][1]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][1]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][1]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][1]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][1]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][1]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][1]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][1]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][1]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][2]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][2]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][2]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][2]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][2]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][2]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][2]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][2]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][2]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][2]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][2]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][2]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][2]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][2]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][2]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][2]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][2]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][2]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][2]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][2]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][2]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][2]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][2]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][2]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][2]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][2]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][2]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][2]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][2]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][2]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[109][2]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][2]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][2]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][2]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][2]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][2]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][2]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][2]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][2]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][2]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][2]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][2]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][2]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][2]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][2]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][2]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][2]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][2]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][2]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][2]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[157][2]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][2]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][2]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][2]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][2]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][2]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][2]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][2]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][2]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][2]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][2]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][2]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][2]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][3]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][3]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][3]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][3]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][3]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][3]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][3]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][3]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][3]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][3]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][3]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][3]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][3]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][3]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][3]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][3]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][3]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][3]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][3]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][3]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][3]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][3]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][3]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][3]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][3]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][3]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][3]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[110][3]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][3]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][3]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][3]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][3]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][3]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][3]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][3]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][3]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{3,2}}
 MapToConvert[155][3]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][3]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][3]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][3]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][3]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][3]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][3]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][3]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][3]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][3]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][3]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][4]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][4]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][4]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][4]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][4]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][4]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][4]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][4]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][4]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][4]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][4]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][4]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][4]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][4]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][4]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[101][4]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][4]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][4]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][4]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][4]={3,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][4]={1,2,1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][4]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][4]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[112][4]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][4]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][4]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][4]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][4]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][4]={3,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][4]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][4]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][4]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][4]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][4]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][4]={3,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][4]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][4]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][4]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][5]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][5]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][5]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][5]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][5]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][5]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][5]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[109][5]={1,1,1,4,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[110][5]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[111][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[154][5]={3,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][5]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{2,5}}
 MapToConvert[156][5]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][5]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[162][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][5]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][5]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][6]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[24][6]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[26][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][6]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][6]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][6]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][6]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][6]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][6]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][6]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][6]={0,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][6]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][6]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][6]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][6]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][6]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][6]={3,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][6]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][6]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[157][6]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[158][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][6]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][6]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][6]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][7]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][7]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[23][7]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[24][7]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][7]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][7]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][7]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][7]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][7]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][7]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][7]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][7]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][7]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][7]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][7]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][7]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][7]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[100][7]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][7]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[108][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][7]={0,1,1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][7]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[112][7]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][7]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][7]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][7]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][7]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[159][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][7]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][7]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][8]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][8]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][8]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][8]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][8]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][8]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{19,1}}
 MapToConvert[26][8]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[27][8]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[28][8]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][8]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][8]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][8]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][8]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][8]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][8]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][8]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][8]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][8]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][8]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][8]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][8]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][8]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][8]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][8]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][8]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][8]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[95][8]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][8]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][8]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][8]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][8]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][8]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][8]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][8]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[103][8]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][8]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][8]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][8]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][8]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][8]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][8]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][8]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][8]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][8]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][8]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][8]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][8]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[155][8]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][8]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[157][8]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][8]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][8]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][8]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][8]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][9]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][9]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][9]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][9]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][9]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][9]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[26][9]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][9]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[28][9]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][9]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][9]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][9]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][9]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][9]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][9]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][9]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][9]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][9]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][9]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][9]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][9]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[100][9]={0,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][9]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{2,2}}
 MapToConvert[102][9]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[104][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][9]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][9]={0,1,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[113][9]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][9]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[154][9]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][9]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][9]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][9]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[158][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][9]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][9]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][10]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][10]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][10]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][10]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][10]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{4,3}}
 MapToConvert[25][10]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][10]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[27][10]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][10]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[29][10]={0,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][10]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][10]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[32][10]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][10]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][10]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][10]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][10]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][10]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[89][10]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[92][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][10]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][10]={1,1,-1,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[98][10]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][10]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][10]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][10]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][10]={0,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][10]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][10]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{6,1}}
 MapToConvert[113][10]={0,1,5,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][10]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[115][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][10]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][10]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[156][10]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][10]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[158][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][10]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][10]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][11]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][11]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][11]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][11]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{19,1}}
 MapToConvert[25][11]={2,1,-1,3,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[26][11]={2,2,4,3,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[27][11]={1,0,-1,3,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[28][11]={1,0,-1,3,{{1,2},{1,3},{1,1}},{-1,0}}
 MapToConvert[29][11]={0,1,-1,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][11]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][11]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][11]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][11]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][11]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][11]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][11]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{0,5}}
 MapToConvert[87][11]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][11]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][11]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][11]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][11]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[95][11]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][11]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][11]={1,2,-1,1,{{0,-1},{0,-1},{1,4}},{7,1}}
 MapToConvert[98][11]={1,2,-1,1,{{1,5},{1,3},{1,4}},{25,1}}
 MapToConvert[99][11]={0,2,-1,1,{{1,5},{0,-1},{1,4}},{6,1}}
 MapToConvert[100][11]={0,1,5,1,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[101][11]={0,0,-1,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[102][11]={0,1,5,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][11]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[104][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][11]={5,3,17,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[111][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][11]={0,2,5,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][11]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][11]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][11]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][11]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][11]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][11]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][11]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[162][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][11]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][11]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][12]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][12]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][12]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[26][12]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][12]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][12]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{19,1}}
 MapToConvert[29][12]={1,1,-1,3,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[30][12]={1,1,-1,3,{{1,5},{0,-1},{0,-1}},{12,1}}
 MapToConvert[31][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][12]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][12]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[85][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][12]={0,2,5,2,{{0,-1},{0,-1},{1,4}},{9,1}}
 MapToConvert[87][12]={1,1,-1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][12]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][12]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][12]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][12]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][12]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][12]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][12]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][12]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][12]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[97][12]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][12]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][12]={2,1,-1,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[100][12]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][12]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][12]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{0,4}}
 MapToConvert[103][12]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][12]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[105][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[106][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][12]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{0,2}}
 MapToConvert[113][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[116][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][12]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][12]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][12]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[157][12]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][12]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[159][12]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][12]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][12]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][12]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[20][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][13]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][13]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][13]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[24][13]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][13]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][13]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][13]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][13]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{5,3}}
 MapToConvert[29][13]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][13]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][13]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][13]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][13]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][13]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][13]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][13]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][13]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][13]={2,2,3,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][13]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][13]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][13]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{2,3}}
 MapToConvert[91][13]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][13]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][13]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][13]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][13]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][13]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{15,1}}
 MapToConvert[97][13]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][13]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][13]={1,2,-1,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[100][13]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][13]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][13]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{2,4}}
 MapToConvert[103][13]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[104][13]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][13]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][13]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][13]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][13]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][13]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][13]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][13]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][13]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][13]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][13]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][13]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{3,2}}
 MapToConvert[154][13]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][13]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][13]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[157][13]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][13]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][13]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[160][13]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][13]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][13]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][13]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][14]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][14]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][14]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][14]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][14]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][14]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[28][14]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][14]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[30][14]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][14]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][14]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][14]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][14]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[38][14]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][14]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][14]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][14]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][14]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[86][14]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][14]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][14]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][14]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][14]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][14]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][14]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][14]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][14]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][14]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][14]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][14]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][14]={2,2,3,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[99][14]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][14]={2,2,4,1,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[101][14]={1,2,-1,1,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[102][14]={0,2,5,1,{{1,5},{0,-1},{0,-1}},{9,1}}
 MapToConvert[103][14]={0,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][14]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][14]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[107][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][14]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][14]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][14]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][14]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][14]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][14]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][14]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][14]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][14]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][14]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][14]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][14]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][14]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][14]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[155][14]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][14]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][14]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][14]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][14]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[160][14]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][14]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[162][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][14]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][14]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][14]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][14]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][14]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][15]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][15]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][15]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[23][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[25][15]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][15]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][15]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][15]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][15]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][15]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{19,1}}
 MapToConvert[31][15]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][15]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{19,1}}
 MapToConvert[36][15]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][15]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][15]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][15]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][15]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][15]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][15]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][15]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[49][15]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][15]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][15]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][15]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][15]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{5,8}}
 MapToConvert[87][15]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][15]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][15]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][15]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][15]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][15]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][15]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][15]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][15]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][15]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][15]={2,2,-1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[98][15]={2,2,-1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][15]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][15]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][15]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][15]={0,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][15]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][15]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[105][15]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][15]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][15]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][15]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][15]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][15]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][15]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][15]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][15]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[135][15]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][15]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][15]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][15]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][15]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[156][15]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][15]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][15]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][15]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][15]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][15]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][15]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][15]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][15]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][15]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[20][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][16]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][16]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[24][16]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][16]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][16]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][16]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{2,4}}
 MapToConvert[28][16]={1,2,-1,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[29][16]={1,2,5,3,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[30][16]={1,2,-1,3,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[31][16]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{15,1}}
 MapToConvert[32][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][16]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[37][16]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][16]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[40][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][16]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][16]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][16]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][16]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][16]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][16]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][16]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][16]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][16]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][16]={2,0,21,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][16]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][16]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][16]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][16]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][16]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][16]={2,1,-1,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[99][16]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[100][16]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][16]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[102][16]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][16]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[104][16]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{4,4}}
 MapToConvert[105][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][16]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][16]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[157][16]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][16]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][16]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][16]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[161][16]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][16]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][16]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][16]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][16]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][17]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][17]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][17]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][17]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][17]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][17]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][17]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][17]={1,1,-1,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[28][17]={1,1,5,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][17]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[30][17]={1,2,-1,3,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[31][17]={1,2,-1,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[34][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][17]={1,2,1,3,{{1,5},{0,-1},{1,4}},{22,1}}
 MapToConvert[37][17]={1,2,-1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][17]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{0,4}}
 MapToConvert[39][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][17]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][17]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[50][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][17]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][17]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][17]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][17]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][17]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][17]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][17]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][17]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][17]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][17]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[94][17]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][17]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][17]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][17]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][17]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][17]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][17]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][17]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][17]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[103][17]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[106][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][17]={5,3,17,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][17]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][17]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][17]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][17]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][17]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][17]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][17]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][17]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][17]={0,2,-1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[161][17]={0,2,5,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][17]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][17]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[165][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][17]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][17]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][18]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[21][18]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][18]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][18]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{19,1}}
 MapToConvert[24][18]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][18]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[26][18]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{1,3}}
 MapToConvert[27][18]={1,2,-1,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[28][18]={1,2,5,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][18]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][18]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][18]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[32][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][18]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][18]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][18]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][18]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[40][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][18]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][18]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][18]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][18]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][18]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][18]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][18]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][18]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{15,1}}
 MapToConvert[92][18]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][18]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][18]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][18]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][18]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][18]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][18]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][18]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][18]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][18]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[102][18]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][18]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][18]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][18]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][18]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{2,5}}
 MapToConvert[157][18]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][18]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[159][18]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][18]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][18]={0,2,-1,1,{{0,-1},{1,0},{1,1}},{33,1}}
 MapToConvert[162][18]={0,2,5,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[163][18]={0,2,-1,1,{{1,2},{0,-1},{0,-1}},{7,1}}
 MapToConvert[164][18]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][18]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][18]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][19]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][19]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[22][19]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][19]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][19]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][19]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][19]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][19]={1,2,-1,3,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[28][19]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[29][19]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][19]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{19,1}}
 MapToConvert[31][19]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][19]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[37][19]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][19]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[41][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][19]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][19]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[87][19]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][19]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][19]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][19]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][19]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][19]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][19]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][19]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][19]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][19]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][19]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][19]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][19]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][19]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][19]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][19]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][19]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][19]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][19]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][19]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][19]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][19]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[158][19]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][19]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[160][19]={0,2,-1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[161][19]={0,2,5,3,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[162][19]={0,2,5,3,{{1,2},{1,3},{1,4}},{4,5}}
 MapToConvert[163][19]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][19]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][19]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[168][19]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][19]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][19]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][20]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][20]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][20]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][20]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][20]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][20]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][20]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[25][20]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][20]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{19,1}}
 MapToConvert[27][20]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[28][20]={1,2,5,3,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[29][20]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][20]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][20]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][20]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][20]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][20]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][20]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][20]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][20]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{15,1}}
 MapToConvert[39][20]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][20]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][20]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[89][20]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][20]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][20]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][20]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][20]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][20]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][20]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][20]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][20]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[98][20]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][20]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][20]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][20]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[102][20]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[106][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][20]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{22,1}}
 MapToConvert[108][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][20]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][20]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[157][20]={3,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][20]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][20]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][20]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][20]={0,2,-1,1,{{0,-1},{1,3},{1,4}},{7,1}}
 MapToConvert[162][20]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][20]={1,1,-1,1,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[164][20]={0,2,5,3,{{1,5},{1,3},{1,4}},{34,1}}
 MapToConvert[165][20]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][20]={0,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][20]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][20]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][20]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][21]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[21][21]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][21]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][21]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][21]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][21]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][21]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][21]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][21]={1,2,5,3,{{0,-1},{0,-1},{1,4}},{21,1}}
 MapToConvert[29][21]={1,2,5,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[30][21]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[31][21]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][21]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][21]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][21]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][21]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[86][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][21]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][21]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[90][21]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][21]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][21]={2,2,3,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][21]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][21]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][21]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][21]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][21]={1,2,1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[98][21]={1,1,1,1,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[99][21]={1,2,1,1,{{1,5},{0,-1},{1,4}},{10,1}}
 MapToConvert[100][21]={1,2,1,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][21]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[109][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][21]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][21]={2,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][21]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{0,4}}
 MapToConvert[157][21]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][21]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][21]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][21]={0,1,-1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[161][21]={0,2,-1,1,{{1,2},{0,-1},{1,4}},{-1,0}}
 MapToConvert[162][21]={0,2,-1,1,{{1,5},{1,3},{1,4}},{6,1}}
 MapToConvert[163][21]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[164][21]={0,2,5,3,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[165][21]={0,0,-1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][21]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[168][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][21]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][21]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][21]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][22]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][22]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][22]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][22]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[24][22]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][22]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][22]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][22]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][22]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][22]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][22]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][22]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][22]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][22]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[38][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][22]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][22]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][22]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[94][22]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][22]={1,2,1,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][22]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][22]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[103][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][22]={5,3,17,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][22]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[121][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][22]={2,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[157][22]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][22]={3,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][22]={3,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][22]={0,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][22]={1,2,1,1,{{0,-1},{1,3},{1,4}},{24,1}}
 MapToConvert[162][22]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][22]={0,2,-1,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[164][22]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{41,1}}
 MapToConvert[165][22]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][22]={0,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][22]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][22]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[169][22]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][22]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][22]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][22]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[20][23]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][23]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][23]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{19,1}}
 MapToConvert[23][23]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[24][23]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[25][23]={0,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][23]={0,1,1,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[27][23]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][23]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[29][23]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][23]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][23]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][23]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][23]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][23]={0,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][23]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[92][23]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][23]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][23]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[97][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][23]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[99][23]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][23]={5,3,10,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][23]={5,3,17,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][23]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[118][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[122][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][23]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][23]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][23]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][23]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[156][23]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][23]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][23]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][23]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][23]={1,2,1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[161][23]={1,2,1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][23]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][23]={1,1,1,1,{{0,-1},{1,3},{1,4}},{0,4}}
 MapToConvert[164][23]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][23]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][23]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[167][23]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[168][23]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][23]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][23]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][23]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][23]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][24]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][24]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{24,1}}
 MapToConvert[22][24]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][24]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[24][24]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][24]={0,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][24]={0,1,1,3,{{0,-1},{1,0},{0,-1}},{2,3}}
 MapToConvert[27][24]={0,2,1,3,{{1,5},{1,0},{0,-1}},{-1,0}}
 MapToConvert[28][24]={1,2,5,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][24]={1,1,5,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[30][24]={1,1,5,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[31][24]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][24]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{22,1}}
 MapToConvert[33][24]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{5,5}}
 MapToConvert[34][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[35][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][24]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][24]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[85][24]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][24]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][24]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][24]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{22,1}}
 MapToConvert[94][24]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][24]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][24]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][24]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[100][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][24]={5,3,10,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][24]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][24]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][24]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][24]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][24]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][24]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[157][24]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][24]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][24]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[160][24]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][24]={1,2,1,1,{{0,-1},{1,3},{1,4}},{10,1}}
 MapToConvert[162][24]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[163][24]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][24]={0,2,2,1,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[165][24]={1,2,-1,1,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[166][24]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][24]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][24]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{2,4}}
 MapToConvert[169][24]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{1,5}}
 MapToConvert[170][24]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][24]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][24]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][24]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][25]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][25]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[21][25]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][25]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][25]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][25]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{19,1}}
 MapToConvert[25][25]={1,2,1,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[26][25]={1,2,-1,3,{{1,5},{1,0},{0,-1}},{-1,0}}
 MapToConvert[27][25]={1,2,1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][25]={1,2,1,3,{{0,-1},{1,0},{0,-1}},{41,1}}
 MapToConvert[29][25]={1,2,1,3,{{1,5},{0,-1},{0,-1}},{34,1}}
 MapToConvert[30][25]={0,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][25]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][25]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][25]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][25]={0,2,11,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[80][25]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][25]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][25]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[83][25]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{24,1}}
 MapToConvert[84][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][25]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][25]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[90][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][25]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][25]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][25]={5,3,10,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][25]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{24,1}}
 MapToConvert[109][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[112][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][25]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[114][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[116][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][25]={5,3,17,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][25]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[151][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][25]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][25]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][25]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][25]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][25]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][25]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][25]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][25]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][25]={1,2,1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[161][25]={1,2,1,1,{{1,2},{0,-1},{0,-1}},{17,1}}
 MapToConvert[162][25]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][25]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][25]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][25]={1,2,5,3,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[166][25]={1,2,-1,1,{{1,5},{1,3},{1,4}},{33,1}}
 MapToConvert[167][25]={0,1,5,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[168][25]={1,0,-1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[170][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][25]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][25]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][25]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][26]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{41,1}}
 MapToConvert[20][26]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][26]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][26]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{24,1}}
 MapToConvert[23][26]={1,1,1,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[24][26]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[25][26]={1,2,1,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[26][26]={1,2,1,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[27][26]={1,2,1,3,{{1,5},{1,0},{0,-1}},{10,1}}
 MapToConvert[28][26]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][26]={1,2,1,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[30][26]={0,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][26]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][26]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{0,5}}
 MapToConvert[33][26]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{4,5}}
 MapToConvert[34][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][26]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[48][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[78][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][26]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][26]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{22,1}}
 MapToConvert[82][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[86][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][26]={5,3,17,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[102][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][26]={5,3,17,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][26]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][26]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][26]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{15,1}}
 MapToConvert[154][26]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][26]={1,0,15,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][26]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][26]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][26]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{5,5}}
 MapToConvert[159][26]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][26]={1,2,1,1,{{0,-1},{1,3},{0,-1}},{41,1}}
 MapToConvert[161][26]={1,2,1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][26]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][26]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[164][26]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][26]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{4,3}}
 MapToConvert[166][26]={1,1,5,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[167][26]={1,1,-1,1,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[168][26]={0,1,5,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[169][26]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][26]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][26]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][26]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][27]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][27]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[20][27]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][27]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[22][27]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][27]={1,1,1,3,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[24][27]={1,2,1,3,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[25][27]={1,2,1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][27]={0,2,2,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[27][27]={1,2,1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][27]={0,2,2,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[29][27]={1,2,1,3,{{1,5},{0,-1},{0,-1}},{24,1}}
 MapToConvert[30][27]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][27]={0,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][27]={1,0,23,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][27]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{1,4}}
 MapToConvert[34][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[35][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][27]={0,2,1,2,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[75][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][27]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[78][27]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[86][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[88][27]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{22,1}}
 MapToConvert[89][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][27]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][27]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[117][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][27]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[131][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][27]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][27]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][27]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][27]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][27]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[155][27]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][27]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][27]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][27]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][27]={1,2,1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[160][27]={1,2,1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][27]={1,1,1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[162][27]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][27]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][27]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][27]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][27]={1,2,-1,1,{{0,-1},{1,0},{1,1}},{6,1}}
 MapToConvert[167][27]={1,1,-1,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][27]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{24,1}}
 MapToConvert[169][27]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][27]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][27]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][27]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][27]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][28]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{19,1}}
 MapToConvert[20][28]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[21][28]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][28]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][28]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][28]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{41,1}}
 MapToConvert[25][28]={1,2,1,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[26][28]={1,2,1,3,{{1,5},{1,3},{1,4}},{21,1}}
 MapToConvert[27][28]={1,2,1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][28]={1,2,1,3,{{0,-1},{1,0},{0,-1}},{41,1}}
 MapToConvert[29][28]={1,2,1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][28]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][28]={0,2,22,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][28]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][28]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][28]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][28]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][28]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][28]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[78][28]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][28]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[83][28]={1,2,1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[84][28]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[85][28]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][28]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][28]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][28]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[96][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][28]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][28]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][28]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[103][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[130][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][28]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{18,1}}
 MapToConvert[152][28]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[153][28]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][28]={1,0,-1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[155][28]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][28]={1,1,1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[157][28]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][28]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[159][28]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][28]={1,2,1,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[161][28]={1,1,1,1,{{0,-1},{1,0},{1,1}},{12,1}}
 MapToConvert[162][28]={1,1,1,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][28]={1,1,-1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[164][28]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[165][28]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[166][28]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][28]={1,1,5,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[168][28]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][28]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[170][28]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][28]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][28]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][28]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][28]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][28]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][29]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][29]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][29]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[22][29]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][29]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[24][29]={1,2,1,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[25][29]={0,2,2,3,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[26][29]={1,2,1,3,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[27][29]={1,2,1,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[28][29]={1,2,1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][29]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[30][29]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][29]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][29]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][29]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][29]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][29]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[38][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][29]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][29]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][29]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[77][29]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][29]={0,2,2,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][29]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][29]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{22,1}}
 MapToConvert[83][29]={1,1,1,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[84][29]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[85][29]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][29]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][29]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][29]={5,3,17,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][29]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][29]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[99][29]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][29]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][29]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][29]={5,3,17,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[113][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][29]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][29]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][29]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][29]={1,0,-1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[154][29]={1,2,1,1,{{1,5},{1,0},{0,-1}},{21,1}}
 MapToConvert[155][29]={1,2,1,1,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[156][29]={1,2,1,1,{{1,5},{0,-1},{0,-1}},{41,1}}
 MapToConvert[157][29]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][29]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][29]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][29]={1,1,1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[161][29]={1,2,1,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][29]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{2,3}}
 MapToConvert[163][29]={0,1,-1,1,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[164][29]={1,1,-1,1,{{0,-1},{1,0},{0,-1}},{30,1}}
 MapToConvert[165][29]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[166][29]={1,2,-1,1,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[167][29]={1,2,5,3,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[168][29]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][29]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][29]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{2,3}}
 MapToConvert[171][29]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][29]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][29]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][29]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][29]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][30]={1,2,1,3,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[20][30]={1,2,1,3,{{1,5},{0,-1},{1,4}},{41,1}}
 MapToConvert[21][30]={1,2,1,3,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[22][30]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[23][30]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][30]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][30]={1,2,1,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[26][30]={1,2,1,3,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[27][30]={1,2,1,3,{{1,5},{1,3},{1,4}},{24,1}}
 MapToConvert[28][30]={1,2,1,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[29][30]={0,1,-1,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[30][30]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][30]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[32][30]={0,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][30]={0,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][30]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][30]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][30]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[40][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][30]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[63][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][30]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][30]={1,2,1,2,{{0,-1},{1,0},{0,-1}},{22,1}}
 MapToConvert[76][30]={1,2,1,2,{{1,5},{0,-1},{1,4}},{23,1}}
 MapToConvert[77][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][30]={0,2,-1,2,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[82][30]={1,2,1,2,{{1,5},{1,3},{1,4}},{22,1}}
 MapToConvert[83][30]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[84][30]={1,1,1,2,{{0,-1},{1,3},{1,4}},{16,1}}
 MapToConvert[85][30]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[86][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][30]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{1,4}}
 MapToConvert[89][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][30]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[91][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][30]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][30]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][30]={1,1,1,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[98][30]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][30]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][30]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[101][30]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][30]={5,3,17,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][30]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{22,1}}
 MapToConvert[115][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][30]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][30]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][30]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[152][30]={0,1,5,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[153][30]={0,1,-1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[154][30]={1,2,1,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][30]={1,2,1,1,{{0,-1},{1,0},{1,1}},{9,1}}
 MapToConvert[156][30]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][30]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][30]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{0,2}}
 MapToConvert[159][30]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{41,1}}
 MapToConvert[160][30]={0,2,2,1,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[161][30]={1,2,1,1,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[162][30]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][30]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{41,1}}
 MapToConvert[164][30]={1,2,1,1,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[165][30]={1,2,1,1,{{0,-1},{1,0},{1,1}},{24,1}}
 MapToConvert[166][30]={0,2,2,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][30]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{5,3}}
 MapToConvert[168][30]={1,2,5,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[169][30]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[170][30]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][30]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[172][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][30]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][30]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][30]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[9][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[13][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][31]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][31]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[21][31]={1,2,1,3,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[22][31]={1,1,1,3,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[23][31]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][31]={1,2,1,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[25][31]={1,2,1,3,{{1,5},{0,-1},{0,-1}},{10,1}}
 MapToConvert[26][31]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][31]={1,2,1,3,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[28][31]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{41,1}}
 MapToConvert[29][31]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][31]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][31]={0,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][31]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][31]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][31]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{19,1}}
 MapToConvert[35][31]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][31]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][31]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][31]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[72][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][31]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{24,1}}
 MapToConvert[74][31]={1,2,1,2,{{0,-1},{0,-1},{1,1}},{9,1}}
 MapToConvert[75][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[79][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[81][31]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][31]={0,2,-1,2,{{0,-1},{0,-1},{1,4}},{6,1}}
 MapToConvert[83][31]={1,1,1,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[84][31]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][31]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{24,1}}
 MapToConvert[86][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][31]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][31]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[91][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][31]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][31]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][31]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[96][31]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][31]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][31]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[99][31]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][31]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][31]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][31]={5,3,17,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][31]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][31]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][31]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][31]={0,1,5,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[152][31]={0,1,5,3,{{1,5},{0,-1},{0,-1}},{4,4}}
 MapToConvert[153][31]={1,2,1,1,{{0,-1},{1,0},{1,1}},{21,1}}
 MapToConvert[154][31]={1,2,1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[155][31]={1,2,1,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][31]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[157][31]={1,1,1,1,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[158][31]={1,2,1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[159][31]={1,2,1,1,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[160][31]={1,2,1,1,{{1,5},{1,0},{0,-1}},{-1,0}}
 MapToConvert[161][31]={1,2,1,1,{{1,5},{1,0},{0,-1}},{10,1}}
 MapToConvert[162][31]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][31]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][31]={1,2,1,1,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[165][31]={1,2,1,1,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[166][31]={0,2,2,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][31]={1,2,5,3,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[168][31]={1,2,-1,1,{{1,2},{0,-1},{1,1}},{6,1}}
 MapToConvert[169][31]={1,2,-1,1,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[170][31]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][31]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][31]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][31]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][32]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][32]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][32]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[19][32]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][32]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{24,1}}
 MapToConvert[21][32]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][32]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{4,4}}
 MapToConvert[23][32]={1,1,1,3,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[24][32]={1,1,1,3,{{1,5},{0,-1},{1,4}},{2,5}}
 MapToConvert[25][32]={0,2,-1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][32]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{19,1}}
 MapToConvert[27][32]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][32]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{24,1}}
 MapToConvert[29][32]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][32]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{2,4}}
 MapToConvert[31][32]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[32][32]={0,1,-1,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[33][32]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[34][32]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[35][32]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][32]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{15,1}}
 MapToConvert[37][32]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][32]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][32]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[42][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][32]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][32]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][32]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][32]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][32]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[77][32]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][32]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][32]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{22,1}}
 MapToConvert[83][32]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[84][32]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][32]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][32]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][32]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][32]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][32]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{24,1}}
 MapToConvert[94][32]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][32]={1,1,1,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[97][32]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[98][32]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{22,1}}
 MapToConvert[99][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][32]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][32]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][32]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[151][32]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][32]={0,2,5,3,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[153][32]={1,2,1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[154][32]={1,2,1,1,{{1,2},{1,3},{1,1}},{-1,0}}
 MapToConvert[155][32]={1,2,1,1,{{1,2},{1,0},{1,1}},{41,1}}
 MapToConvert[156][32]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][32]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][32]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][32]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[160][32]={1,2,1,1,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[161][32]={1,2,1,1,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[162][32]={1,2,1,1,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[163][32]={0,2,2,1,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[164][32]={1,2,1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[165][32]={1,2,1,1,{{1,5},{1,0},{0,-1}},{21,1}}
 MapToConvert[166][32]={1,2,1,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][32]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[168][32]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][32]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][32]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][32]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][33]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{19,1}}
 MapToConvert[8][33]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[9][33]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][33]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][33]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{22,1}}
 MapToConvert[12][33]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][33]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][33]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][33]={1,2,1,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[18][33]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{41,1}}
 MapToConvert[19][33]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][33]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[21][33]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][33]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][33]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][33]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][33]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][33]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][33]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[28][33]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][33]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][33]={1,1,5,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[31][33]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][33]={1,2,5,3,{{0,-1},{1,0},{1,1}},{9,1}}
 MapToConvert[33][33]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][33]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][33]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][33]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][33]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[38][33]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][33]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[60][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][33]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[63][33]={0,0,18,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][33]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[73][33]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][33]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[76][33]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[77][33]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][33]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][33]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][33]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[86][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][33]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[101][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[113][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][33]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][33]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][33]={0,2,-1,1,{{0,-1},{1,3},{0,-1}},{6,1}}
 MapToConvert[152][33]={1,2,1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[153][33]={1,2,1,1,{{1,2},{0,-1},{1,1}},{24,1}}
 MapToConvert[154][33]={1,2,1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][33]={0,2,2,1,{{0,-1},{1,3},{1,1}},{-1,0}}
 MapToConvert[156][33]={1,2,1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[157][33]={1,2,1,1,{{1,2},{0,-1},{1,1}},{10,1}}
 MapToConvert[158][33]={0,2,2,1,{{1,2},{1,3},{1,1}},{-1,0}}
 MapToConvert[159][33]={0,2,2,1,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[160][33]={1,2,1,1,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[161][33]={1,2,1,1,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[162][33]={1,2,1,1,{{0,-1},{1,0},{1,1}},{21,1}}
 MapToConvert[163][33]={1,2,1,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][33]={1,2,1,1,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[165][33]={1,2,1,1,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[166][33]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[167][33]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][33]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][33]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][33]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][34]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][34]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[9][34]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][34]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{24,1}}
 MapToConvert[11][34]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][34]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][34]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][34]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[15][34]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][34]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][34]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[18][34]={1,2,1,3,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[19][34]={0,2,14,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[20][34]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][34]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][34]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][34]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{15,1}}
 MapToConvert[24][34]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][34]={1,2,1,3,{{0,-1},{1,0},{0,-1}},{41,1}}
 MapToConvert[26][34]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][34]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[28][34]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][34]={1,2,5,3,{{0,-1},{1,0},{1,1}},{19,1}}
 MapToConvert[30][34]={1,1,5,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[31][34]={1,2,5,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][34]={1,2,-1,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[33][34]={1,2,-1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][34]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][34]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][34]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[37][34]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][34]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][34]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{2,5}}
 MapToConvert[40][34]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][34]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][34]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{22,1}}
 MapToConvert[64][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][34]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][34]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][34]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[76][34]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{22,1}}
 MapToConvert[77][34]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][34]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][34]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[96][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[100][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][34]={5,3,17,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][34]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][34]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][34]={0,0,-1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[152][34]={1,2,1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][34]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{41,1}}
 MapToConvert[154][34]={1,2,1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[155][34]={1,2,1,1,{{1,2},{0,-1},{1,1}},{21,1}}
 MapToConvert[156][34]={1,2,1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][34]={1,2,1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[158][34]={1,2,1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[159][34]={1,2,1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][34]={1,2,1,1,{{0,-1},{1,3},{1,1}},{-1,0}}
 MapToConvert[161][34]={1,2,1,1,{{1,2},{0,-1},{1,1}},{24,1}}
 MapToConvert[162][34]={1,2,1,1,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[163][34]={0,2,2,1,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[164][34]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[165][34]={1,2,1,1,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[166][34]={1,2,1,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[168][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][34]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][34]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][34]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[6][35]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[7][35]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][35]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][35]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[10][35]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][35]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{22,1}}
 MapToConvert[12][35]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[13][35]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][35]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][35]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[16][35]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][35]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][35]={1,2,1,3,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[19][35]={1,2,1,3,{{1,5},{0,-1},{0,-1}},{22,1}}
 MapToConvert[20][35]={1,1,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][35]={0,2,-1,3,{{0,-1},{0,-1},{0,-1}},{19,1}}
 MapToConvert[22][35]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][35]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][35]={1,2,5,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[25][35]={1,2,5,3,{{1,5},{1,0},{0,-1}},{-1,0}}
 MapToConvert[26][35]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][35]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][35]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{24,1}}
 MapToConvert[29][35]={1,2,5,3,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[30][35]={1,2,5,3,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[31][35]={1,2,5,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[32][35]={1,1,5,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][35]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][35]={1,2,5,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[35][35]={1,1,-1,3,{{1,5},{1,3},{1,4}},{0,4}}
 MapToConvert[36][35]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][35]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][35]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][35]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][35]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{22,1}}
 MapToConvert[61][35]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][35]={0,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][35]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][35]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[76][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[80][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[84][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][35]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][35]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][35]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{4,5}}
 MapToConvert[91][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][35]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][35]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][35]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][35]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{24,1}}
 MapToConvert[152][35]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][35]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][35]={1,2,16,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][35]={1,2,1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[156][35]={1,2,1,1,{{1,2},{0,-1},{1,1}},{24,1}}
 MapToConvert[157][35]={0,0,-1,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][35]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][35]={1,2,1,1,{{0,-1},{1,3},{0,-1}},{9,1}}
 MapToConvert[160][35]={1,2,1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][35]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][35]={1,2,1,1,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[163][35]={1,2,1,1,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[164][35]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][35]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][35]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][35]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][35]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][36]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][36]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][36]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[9][36]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][36]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[11][36]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][36]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][36]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{22,1}}
 MapToConvert[14][36]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][36]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[16][36]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][36]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{22,1}}
 MapToConvert[18][36]={1,2,1,3,{{0,-1},{0,-1},{0,-1}},{24,1}}
 MapToConvert[19][36]={1,1,5,3,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[20][36]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][36]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][36]={1,1,5,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[23][36]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[24][36]={1,2,5,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[25][36]={1,2,5,3,{{1,5},{1,0},{0,-1}},{-1,0}}
 MapToConvert[26][36]={1,2,5,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][36]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[28][36]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][36]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][36]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[31][36]={1,2,5,3,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[32][36]={1,2,5,3,{{1,2},{1,0},{1,1}},{21,1}}
 MapToConvert[33][36]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][36]={1,2,-1,3,{{0,-1},{1,0},{0,-1}},{8,1}}
 MapToConvert[35][36]={1,0,-1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][36]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[38][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[42][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][36]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][36]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][36]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[63][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[65][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[73][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][36]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[75][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][36]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][36]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][36]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[93][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][36]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[109][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[112][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][36]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][36]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{2,4}}
 MapToConvert[153][36]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][36]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][36]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][36]={1,2,1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][36]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][36]={0,0,-1,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[159][36]={1,2,1,1,{{1,2},{0,-1},{1,1}},{41,1}}
 MapToConvert[160][36]={0,2,2,1,{{1,2},{1,3},{1,4}},{-1,0}}
 MapToConvert[161][36]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][36]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{15,1}}
 MapToConvert[163][36]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][36]={0,2,2,1,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[165][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][36]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][36]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][36]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][36]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][37]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[6][37]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[7][37]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][37]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[9][37]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[10][37]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][37]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{19,1}}
 MapToConvert[12][37]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][37]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][37]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][37]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][37]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][37]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][37]={1,2,5,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[19][37]={1,2,5,3,{{1,2},{0,-1},{1,4}},{-1,0}}
 MapToConvert[20][37]={1,1,5,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[21][37]={1,1,5,3,{{1,5},{0,-1},{1,4}},{0,5}}
 MapToConvert[22][37]={1,2,5,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][37]={1,2,5,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[24][37]={1,2,-1,3,{{1,5},{0,-1},{1,4}},{8,1}}
 MapToConvert[25][37]={1,2,-1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][37]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{19,1}}
 MapToConvert[27][37]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][37]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[29][37]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][37]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[31][37]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][37]={1,2,5,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[33][37]={1,2,5,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[34][37]={1,1,-1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][37]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][37]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[39][37]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[58][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][37]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][37]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][37]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{24,1}}
 MapToConvert[62][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][37]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{22,1}}
 MapToConvert[70][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][37]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[74][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][37]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{4,3}}
 MapToConvert[78][37]={0,2,2,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][37]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{24,1}}
 MapToConvert[87][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[105][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][37]={5,3,17,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][37]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][37]={5,3,17,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[149][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][37]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[151][37]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][37]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][37]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{15,1}}
 MapToConvert[154][37]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][37]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{24,1}}
 MapToConvert[156][37]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][37]={0,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][37]={0,0,-1,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][37]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{0,5}}
 MapToConvert[160][37]={1,2,1,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[161][37]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][37]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][37]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][37]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][37]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][37]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][37]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][37]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][38]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][38]={1,2,5,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[7][38]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][38]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][38]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][38]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][38]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][38]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{0,4}}
 MapToConvert[13][38]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[14][38]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][38]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][38]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][38]={1,2,5,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[18][38]={1,2,-1,3,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[19][38]={1,2,-1,3,{{1,2},{0,-1},{0,-1}},{8,1}}
 MapToConvert[20][38]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{19,1}}
 MapToConvert[21][38]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][38]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][38]={1,2,-1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][38]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[26][38]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][38]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][38]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][38]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][38]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][38]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[32][38]={1,2,-1,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[33][38]={1,2,5,3,{{1,5},{1,0},{0,-1}},{-1,0}}
 MapToConvert[34][38]={1,2,-1,3,{{1,5},{0,-1},{0,-1}},{19,1}}
 MapToConvert[35][38]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][38]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][38]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][38]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][38]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[42][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[45][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][38]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][38]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[61][38]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][38]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][38]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[71][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][38]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[77][38]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][38]={0,2,2,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[79][38]={0,2,2,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][38]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[82][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][38]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][38]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[92][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[94][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][38]={5,3,17,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][38]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[112][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][38]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][38]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][38]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][38]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][38]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][38]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][38]={0,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][38]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[160][38]={0,0,-1,3,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[161][38]={0,0,-1,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][38]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][38]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][38]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{24,1}}
 MapToConvert[165][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[167][38]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][38]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][38]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][39]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][39]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][39]={1,2,-1,3,{{0,-1},{1,0},{1,1}},{19,1}}
 MapToConvert[7][39]={1,1,-1,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[8][39]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[9][39]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][39]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[11][39]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][39]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][39]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][39]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][39]={1,2,-1,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[16][39]={1,2,-1,3,{{1,2},{0,-1},{1,1}},{25,1}}
 MapToConvert[17][39]={1,2,-1,3,{{1,2},{0,-1},{0,-1}},{1,5}}
 MapToConvert[18][39]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][39]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][39]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][39]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[22][39]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][39]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{5,5}}
 MapToConvert[24][39]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][39]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][39]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][39]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{0,2}}
 MapToConvert[28][39]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][39]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{19,1}}
 MapToConvert[30][39]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][39]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[32][39]={1,2,-1,3,{{0,-1},{1,0},{1,1}},{6,1}}
 MapToConvert[33][39]={1,2,-1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][39]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][39]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{18,1}}
 MapToConvert[38][39]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][39]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[40][39]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][39]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][39]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][39]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][39]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][39]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][39]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[62][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][39]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][39]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][39]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][39]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[77][39]={1,2,1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[78][39]={1,2,1,2,{{1,2},{0,-1},{0,-1}},{10,1}}
 MapToConvert[79][39]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[87][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][39]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[90][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][39]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[106][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[120][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[149][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][39]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{41,1}}
 MapToConvert[152][39]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][39]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{4,4}}
 MapToConvert[154][39]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][39]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[156][39]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[157][39]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][39]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][39]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][39]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][39]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[162][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][39]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][39]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][39]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][39]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][40]={0,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][40]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[6][40]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][40]={2,2,4,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[8][40]={2,1,-1,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[9][40]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][40]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][40]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][40]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][40]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][40]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[15][40]={1,2,-1,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[16][40]={2,2,4,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][40]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][40]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][40]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][40]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[21][40]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][40]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][40]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][40]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][40]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[26][40]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][40]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[28][40]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][40]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][40]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][40]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][40]={1,2,-1,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[33][40]={1,2,-1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][40]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][40]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][40]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][40]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][40]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][40]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][40]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[43][40]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][40]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][40]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][40]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[60][40]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][40]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{0,4}}
 MapToConvert[62][40]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][40]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][40]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][40]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][40]={1,2,1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[78][40]={1,2,1,2,{{1,2},{1,3},{1,4}},{23,1}}
 MapToConvert[79][40]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][40]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[81][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][40]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[89][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[109][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[112][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][40]={0,1,-1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[151][40]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][40]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][40]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][40]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][40]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{24,1}}
 MapToConvert[156][40]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][40]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][40]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][40]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{22,1}}
 MapToConvert[160][40]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][40]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[164][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][40]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][40]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][40]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][40]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][41]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][41]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][41]={2,2,4,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[7][41]={2,2,-1,3,{{1,5},{0,-1},{0,-1}},{31,1}}
 MapToConvert[8][41]={2,1,-1,3,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[9][41]={2,2,-1,3,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[10][41]={2,2,4,3,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[11][41]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][41]={2,2,-1,3,{{0,-1},{1,3},{0,-1}},{19,1}}
 MapToConvert[13][41]={2,2,4,3,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[14][41]={2,1,-1,3,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[15][41]={2,2,-1,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][41]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][41]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][41]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][41]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][41]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][41]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][41]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][41]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][41]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][41]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][41]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][41]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][41]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][41]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][41]={2,2,4,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[31][41]={2,2,4,3,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[32][41]={1,2,-1,3,{{0,-1},{1,0},{1,1}},{19,1}}
 MapToConvert[33][41]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][41]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{1,4}}
 MapToConvert[37][41]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][41]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][41]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[40][41]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][41]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][41]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][41]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][41]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][41]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{1,1}}
 MapToConvert[46][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][41]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][41]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][41]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][41]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][41]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[63][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[70][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][41]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][41]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][41]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[75][41]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[76][41]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[77][41]={1,2,1,2,{{1,2},{1,3},{0,-1}},{22,1}}
 MapToConvert[78][41]={1,1,1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][41]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][41]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[89][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][41]={5,3,17,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[146][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][41]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][41]={0,1,1,1,{{0,-1},{0,-1},{0,-1}},{0,5}}
 MapToConvert[150][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][41]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[153][41]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][41]={0,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][41]={0,1,5,3,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[157][41]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][41]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[159][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[160][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][41]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][41]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][41]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][41]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][42]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][42]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][42]={2,2,4,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[6][42]={2,2,-1,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[7][42]={2,2,-1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][42]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][42]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][42]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][42]={2,2,4,3,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[12][42]={2,2,4,3,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[13][42]={2,2,4,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][42]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][42]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[16][42]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][42]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][42]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][42]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][42]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][42]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][42]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][42]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][42]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][42]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][42]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][42]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][42]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][42]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][42]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][42]={2,2,4,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[32][42]={2,2,4,3,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[33][42]={2,2,4,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][42]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][42]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][42]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][42]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[38][42]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][42]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][42]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][42]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][42]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][42]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][42]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[45][42]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][42]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][42]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][42]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][42]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[55][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[58][42]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][42]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{22,1}}
 MapToConvert[60][42]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[61][42]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][42]={1,2,-1,2,{{0,-1},{1,3},{0,-1}},{19,1}}
 MapToConvert[63][42]={1,1,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][42]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[65][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][42]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][42]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][42]={1,2,1,2,{{0,-1},{1,3},{1,4}},{22,1}}
 MapToConvert[74][42]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][42]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][42]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][42]={1,2,1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[78][42]={1,1,1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][42]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{22,1}}
 MapToConvert[80][42]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][42]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][42]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][42]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{22,1}}
 MapToConvert[90][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[102][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][42]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[111][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][42]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{15,1}}
 MapToConvert[149][42]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][42]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][42]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][42]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][42]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][42]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][42]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][43]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][43]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[3][43]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][43]={2,2,-1,3,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[5][43]={2,2,3,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][43]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][43]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][43]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][43]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][43]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][43]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][43]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][43]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][43]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][43]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][43]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][43]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][43]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][43]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][43]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][43]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][43]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][43]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{15,1}}
 MapToConvert[24][43]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][43]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[26][43]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][43]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][43]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][43]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[30][43]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{1,3}}
 MapToConvert[31][43]={2,2,4,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[32][43]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[33][43]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][43]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][43]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[36][43]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][43]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[38][43]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][43]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][43]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][43]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][43]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[43][43]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][43]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[45][43]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][43]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[47][43]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][43]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][43]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][43]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][43]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][43]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][43]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{2,3}}
 MapToConvert[59][43]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][43]={1,2,1,2,{{0,-1},{1,3},{0,-1}},{10,1}}
 MapToConvert[61][43]={1,2,1,2,{{1,2},{0,-1},{1,1}},{22,1}}
 MapToConvert[62][43]={1,1,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][43]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][43]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[66][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][43]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{0,4}}
 MapToConvert[71][43]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][43]={0,1,-1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[73][43]={0,0,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][43]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[75][43]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[76][43]={1,1,1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[77][43]={1,2,1,2,{{1,2},{0,-1},{0,-1}},{24,1}}
 MapToConvert[78][43]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[81][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][43]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][43]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][43]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{24,1}}
 MapToConvert[100][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][43]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][43]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[148][43]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[149][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[151][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][43]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][43]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][43]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][43]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][43]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][43]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][43]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][44]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][44]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][44]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][44]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][44]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][44]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[7][44]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][44]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{1,4}}
 MapToConvert[9][44]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][44]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][44]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][44]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][44]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][44]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][44]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][44]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][44]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][44]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][44]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][44]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][44]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][44]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][44]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][44]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][44]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[26][44]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][44]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][44]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][44]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][44]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{15,1}}
 MapToConvert[31][44]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][44]={2,2,4,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[33][44]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][44]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][44]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][44]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][44]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{0,4}}
 MapToConvert[38][44]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][44]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[40][44]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][44]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[42][44]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][44]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][44]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][44]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][44]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][44]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][44]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][44]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][44]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][44]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][44]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][44]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][44]={1,1,-1,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[60][44]={1,1,1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[61][44]={1,1,1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][44]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[63][44]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{1,4}}
 MapToConvert[64][44]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][44]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][44]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{24,1}}
 MapToConvert[67][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][44]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][44]={0,2,-1,2,{{0,-1},{1,3},{0,-1}},{33,1}}
 MapToConvert[73][44]={1,1,1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][44]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][44]={1,1,1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[76][44]={1,1,1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[77][44]={1,2,-1,2,{{1,2},{0,-1},{0,-1}},{24,1}}
 MapToConvert[78][44]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][44]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[140][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][44]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[146][44]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][44]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][44]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][44]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][44]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][44]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][44]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][44]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][44]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][44]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[157][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][44]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][44]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][44]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][44]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][44]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][45]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{4,5}}
 MapToConvert[2][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][45]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][45]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][45]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][45]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][45]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][45]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][45]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][45]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][45]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][45]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][45]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][45]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[16][45]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][45]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][45]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[19][45]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][45]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][45]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][45]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][45]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][45]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][45]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][45]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][45]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][45]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[29][45]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{0,4}}
 MapToConvert[30][45]={2,2,4,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[31][45]={2,2,4,3,{{1,5},{0,-1},{1,4}},{19,1}}
 MapToConvert[32][45]={2,2,4,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][45]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[36][45]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{2,5}}
 MapToConvert[37][45]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[38][45]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][45]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][45]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][45]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][45]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][45]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[57][45]={1,2,1,2,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[58][45]={1,2,1,2,{{1,5},{1,3},{1,4}},{22,1}}
 MapToConvert[59][45]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[60][45]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][45]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][45]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][45]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][45]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{22,1}}
 MapToConvert[65][45]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][45]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][45]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[70][45]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][45]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[72][45]={1,1,1,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[73][45]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][45]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][45]={1,1,1,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[76][45]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[77][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][45]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][45]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[82][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[119][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][45]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][45]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][45]={0,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][45]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[147][45]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][45]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{24,1}}
 MapToConvert[149][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][45]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][45]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][45]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][45]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][46]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][46]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][46]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][46]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][46]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][46]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][46]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][46]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][46]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][46]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][46]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][46]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][46]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][46]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][46]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][46]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][46]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][46]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][46]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][46]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][46]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][46]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][46]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][46]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][46]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][46]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][46]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][46]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][46]={2,2,4,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[31][46]={2,2,4,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][46]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][46]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][46]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[35][46]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][46]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][46]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][46]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][46]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][46]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[41][46]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][46]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][46]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][46]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][46]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][46]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][46]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[48][46]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][46]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][46]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[53][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][46]={2,2,4,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][46]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[57][46]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[58][46]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][46]={1,2,1,2,{{0,-1},{0,-1},{1,4}},{22,1}}
 MapToConvert[60][46]={1,2,1,2,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[61][46]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[62][46]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][46]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[64][46]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][46]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][46]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{19,1}}
 MapToConvert[67][46]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[68][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][46]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][46]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][46]={0,2,-1,2,{{0,-1},{1,3},{0,-1}},{6,1}}
 MapToConvert[73][46]={1,1,1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][46]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][46]={1,2,1,2,{{0,-1},{1,3},{0,-1}},{22,1}}
 MapToConvert[76][46]={1,1,1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][46]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][46]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][46]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{24,1}}
 MapToConvert[82][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][46]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[90][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][46]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][46]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[123][46]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[139][46]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][46]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][46]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][46]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][46]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{15,1}}
 MapToConvert[144][46]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][46]={1,1,1,1,{{0,-1},{1,0},{1,1}},{12,1}}
 MapToConvert[146][46]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[150][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][46]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{41,1}}
 MapToConvert[153][46]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][46]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][46]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{24,1}}
 MapToConvert[157][46]={0,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][46]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][46]={0,2,2,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][46]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][46]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][47]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[6][47]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][47]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[8][47]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][47]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[10][47]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][47]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][47]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{1,2}}
 MapToConvert[13][47]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][47]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][47]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{18,1}}
 MapToConvert[16][47]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][47]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][47]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{5,2}}
 MapToConvert[19][47]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][47]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[21][47]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][47]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[23][47]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[24][47]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][47]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{19,1}}
 MapToConvert[26][47]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][47]={2,2,3,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][47]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][47]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{1,3}}
 MapToConvert[30][47]={2,2,4,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[31][47]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[32][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][47]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][47]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[36][47]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][47]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[38][47]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][47]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][47]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[41][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][47]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[44][47]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][47]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[46][47]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][47]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][47]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][47]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[50][47]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][47]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[52][47]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][47]={2,2,4,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[55][47]={2,2,4,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][47]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][47]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][47]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{19,1}}
 MapToConvert[59][47]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][47]={1,1,-1,2,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[61][47]={1,1,-1,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[62][47]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][47]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{19,1}}
 MapToConvert[64][47]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][47]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[66][47]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[70][47]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][47]={0,2,-1,2,{{0,-1},{1,3},{0,-1}},{7,1}}
 MapToConvert[72][47]={1,1,1,2,{{1,2},{0,-1},{0,-1}},{17,1}}
 MapToConvert[73][47]={0,0,-1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[74][47]={1,1,1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[75][47]={1,1,1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][47]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][47]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[78][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][47]={0,2,-1,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[81][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[86][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[118][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][47]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][47]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[121][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][47]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][47]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{0,5}}
 MapToConvert[141][47]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][47]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][47]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][47]={1,2,1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[145][47]={1,1,1,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][47]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][47]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][47]={1,1,1,1,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[155][47]={1,1,1,1,{{1,5},{0,-1},{1,4}},{12,1}}
 MapToConvert[156][47]={0,1,-1,3,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][47]={0,2,2,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][47]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{15,1}}
 MapToConvert[160][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][47]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][47]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[4][48]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][48]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][48]={1,2,-1,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[7][48]={1,2,-1,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[8][48]={2,0,-1,3,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[9][48]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][48]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][48]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][48]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][48]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][48]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][48]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][48]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][48]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[18][48]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][48]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][48]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{18,1}}
 MapToConvert[21][48]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][48]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][48]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[24][48]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][48]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][48]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{1,3}}
 MapToConvert[27][48]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][48]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[29][48]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{4,4}}
 MapToConvert[30][48]={2,2,4,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[31][48]={0,2,-1,3,{{1,5},{0,-1},{0,-1}},{6,1}}
 MapToConvert[32][48]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][48]={2,0,19,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][48]={2,2,-1,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[35][48]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[36][48]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][48]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][48]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][48]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][48]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][48]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][48]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[43][48]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][48]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][48]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{19,1}}
 MapToConvert[46][48]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[47][48]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][48]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][48]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][48]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][48]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][48]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[53][48]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][48]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][48]={2,2,4,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[56][48]={2,2,4,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][48]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][48]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[59][48]={0,2,-1,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[60][48]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[61][48]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][48]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{2,4}}
 MapToConvert[63][48]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][48]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][48]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][48]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[67][48]={0,2,2,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[68][48]={0,2,2,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][48]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][48]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][48]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][48]={0,0,-1,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[73][48]={0,0,-1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[74][48]={0,1,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][48]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{0,2}}
 MapToConvert[76][48]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][48]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[78][48]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][48]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][48]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][48]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][48]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{22,1}}
 MapToConvert[83][48]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][48]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][48]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][48]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][48]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{22,1}}
 MapToConvert[89][48]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][48]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[101][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][48]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[110][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][48]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][48]={1,1,1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[120][48]={2,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][48]={0,2,-1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][48]={5,3,17,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][48]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][48]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][48]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{4,4}}
 MapToConvert[139][48]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][48]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][48]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[142][48]={0,2,1,1,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[143][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][48]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][48]={0,2,2,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][48]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[147][48]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[148][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][48]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][48]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][48]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][48]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][49]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][49]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][49]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[7][49]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][49]={1,1,-1,3,{{1,2},{0,-1},{0,-1}},{5,4}}
 MapToConvert[9][49]={2,0,-1,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[10][49]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{15,1}}
 MapToConvert[11][49]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][49]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][49]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][49]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[15][49]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][49]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{19,1}}
 MapToConvert[17][49]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][49]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][49]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][49]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][49]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[22][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][49]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][49]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[28][49]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[29][49]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][49]={0,2,-1,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[31][49]={0,2,-1,3,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[32][49]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][49]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][49]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][49]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[36][49]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[37][49]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][49]={2,2,24,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][49]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][49]={2,2,4,3,{{0,-1},{1,3},{0,-1}},{3,4}}
 MapToConvert[41][49]={2,2,4,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][49]={2,2,4,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][49]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][49]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][49]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][49]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][49]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[48][49]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][49]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][49]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{0,4}}
 MapToConvert[51][49]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][49]={2,2,3,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][49]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[54][49]={2,2,4,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[55][49]={2,2,4,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][49]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[57][49]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][49]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[59][49]={0,2,-1,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[60][49]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][49]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][49]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][49]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][49]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[65][49]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][49]={0,2,2,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[67][49]={0,2,2,2,{{1,2},{0,-1},{0,-1}},{7,1}}
 MapToConvert[68][49]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][49]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][49]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][49]={1,1,1,2,{{0,-1},{1,3},{0,-1}},{2,4}}
 MapToConvert[72][49]={1,1,1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][49]={0,0,-1,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[74][49]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][49]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][49]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[77][49]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][49]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[79][49]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][49]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{22,1}}
 MapToConvert[81][49]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][49]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][49]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[84][49]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][49]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][49]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][49]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][49]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[109][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][49]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][49]={1,1,1,1,{{1,5},{0,-1},{0,-1}},{0,1}}
 MapToConvert[120][49]={0,2,-1,1,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[121][49]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[122][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][49]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][49]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][49]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][49]={1,1,1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[139][49]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{15,1}}
 MapToConvert[140][49]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[143][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][49]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{41,1}}
 MapToConvert[146][49]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][49]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][49]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][49]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{41,1}}
 MapToConvert[155][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][49]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][49]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][50]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][50]={1,2,-1,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[8][50]={1,1,5,3,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[9][50]={1,1,-1,3,{{1,5},{0,-1},{1,4}},{8,1}}
 MapToConvert[10][50]={1,1,-1,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[11][50]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][50]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][50]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][50]={2,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][50]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{0,4}}
 MapToConvert[16][50]={2,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][50]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][50]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][50]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[20][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[25][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][50]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][50]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][50]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{18,1}}
 MapToConvert[29][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][50]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][50]={0,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][50]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][50]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][50]={2,2,4,3,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[40][50]={2,2,4,3,{{1,2},{1,3},{1,1}},{-1,0}}
 MapToConvert[41][50]={2,2,4,3,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][50]={2,2,4,2,{{0,-1},{0,-1},{0,-1}},{19,1}}
 MapToConvert[43][50]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][50]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[45][50]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][50]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{2,5}}
 MapToConvert[47][50]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][50]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][50]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[50][50]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][50]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][50]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][50]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][50]={2,2,4,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[55][50]={2,2,4,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][50]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][50]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[58][50]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[59][50]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][50]={0,2,-1,2,{{0,-1},{0,-1},{1,1}},{1,3}}
 MapToConvert[61][50]={0,2,-1,2,{{1,2},{1,3},{1,1}},{-1,0}}
 MapToConvert[62][50]={0,2,-1,2,{{1,2},{1,3},{1,1}},{8,1}}
 MapToConvert[63][50]={0,2,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[64][50]={0,2,-1,2,{{1,2},{1,3},{1,1}},{6,1}}
 MapToConvert[65][50]={0,2,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[66][50]={0,2,-1,2,{{1,2},{0,-1},{1,1}},{19,1}}
 MapToConvert[67][50]={0,2,-1,2,{{1,2},{1,3},{1,4}},{-1,0}}
 MapToConvert[68][50]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][50]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[70][50]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][50]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][50]={0,0,-1,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[73][50]={0,1,-1,2,{{0,-1},{1,3},{0,-1}},{21,1}}
 MapToConvert[74][50]={0,1,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][50]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[76][50]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][50]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][50]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][50]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][50]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][50]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][50]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[83][50]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][50]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][50]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][50]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][50]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][50]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][50]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[92][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][50]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][50]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][50]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][50]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][50]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][50]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][50]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[136][50]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][50]={1,1,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][50]={1,1,1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[139][50]={1,1,-1,1,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[140][50]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][50]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{24,1}}
 MapToConvert[147][50]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][50]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{41,1}}
 MapToConvert[151][50]={0,2,2,1,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[152][50]={0,2,2,1,{{1,5},{0,-1},{0,-1}},{34,1}}
 MapToConvert[153][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[157][50]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][50]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][50]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][51]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][51]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][51]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][51]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][51]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][51]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][51]={1,1,5,3,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[11][51]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{2,4}}
 MapToConvert[12][51]={1,1,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][51]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][51]={1,0,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][51]={2,0,-1,3,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[16][51]={1,1,-1,3,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[17][51]={1,2,-1,3,{{1,2},{1,0},{1,1}},{8,1}}
 MapToConvert[18][51]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][51]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][51]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[31][51]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][51]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][51]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][51]={0,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][51]={1,1,-1,3,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[38][51]={2,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][51]={2,2,4,3,{{0,-1},{1,3},{1,4}},{12,1}}
 MapToConvert[40][51]={2,2,4,3,{{0,-1},{1,3},{1,4}},{27,1}}
 MapToConvert[41][51]={2,2,4,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][51]={2,2,4,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][51]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[44][51]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][51]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[46][51]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][51]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{1,2}}
 MapToConvert[48][51]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][51]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][51]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][51]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[52][51]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][51]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][51]={1,2,-1,2,{{0,-1},{1,3},{1,4}},{19,1}}
 MapToConvert[55][51]={2,2,4,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][51]={2,2,4,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][51]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][51]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[59][51]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][51]={0,2,-1,2,{{0,-1},{1,3},{0,-1}},{25,1}}
 MapToConvert[61][51]={0,2,-1,2,{{1,2},{1,3},{0,-1}},{-1,0}}
 MapToConvert[62][51]={0,2,-1,2,{{1,2},{0,-1},{0,-1}},{21,1}}
 MapToConvert[63][51]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][51]={1,2,5,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[65][51]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][51]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][51]={1,2,5,2,{{0,-1},{0,-1},{1,4}},{9,1}}
 MapToConvert[68][51]={1,2,5,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[69][51]={0,2,-1,2,{{1,5},{1,3},{1,4}},{8,1}}
 MapToConvert[70][51]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][51]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][51]={0,0,-1,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[73][51]={0,1,-1,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[74][51]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{4,4}}
 MapToConvert[75][51]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][51]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][51]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][51]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][51]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[80][51]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][51]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][51]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][51]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[84][51]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][51]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][51]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][51]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[89][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[98][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][51]={5,3,17,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][51]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[117][51]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][51]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][51]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][51]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][51]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][51]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{5,4}}
 MapToConvert[138][51]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][51]={1,1,-1,1,{{0,-1},{0,-1},{1,1}},{18,1}}
 MapToConvert[140][51]={1,2,-1,1,{{1,2},{0,-1},{0,-1}},{40,1}}
 MapToConvert[141][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][51]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{24,1}}
 MapToConvert[149][51]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][51]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][51]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{24,1}}
 MapToConvert[155][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][51]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][51]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][52]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][52]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][52]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[6][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][52]={0,2,12,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][52]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][52]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[14][52]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[15][52]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][52]={1,2,5,3,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[17][52]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{19,1}}
 MapToConvert[18][52]={1,2,5,3,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[19][52]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][52]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[21][52]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][52]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][52]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][52]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{18,1}}
 MapToConvert[30][52]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][52]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[35][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][52]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][52]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[38][52]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[39][52]={2,2,4,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[40][52]={2,2,4,3,{{1,2},{0,-1},{0,-1}},{3,5}}
 MapToConvert[41][52]={2,2,4,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[42][52]={2,2,4,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][52]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][52]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][52]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][52]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][52]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{18,1}}
 MapToConvert[48][52]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][52]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][52]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[51][52]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][52]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][52]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][52]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][52]={1,2,-1,2,{{0,-1},{0,-1},{1,4}},{8,1}}
 MapToConvert[56][52]={1,2,-1,2,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[57][52]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[58][52]={2,2,4,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][52]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][52]={0,2,5,2,{{0,-1},{1,3},{0,-1}},{9,1}}
 MapToConvert[61][52]={0,2,-1,2,{{1,2},{1,3},{0,-1}},{-1,0}}
 MapToConvert[62][52]={0,2,-1,2,{{1,2},{0,-1},{0,-1}},{21,1}}
 MapToConvert[63][52]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][52]={0,2,5,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[65][52]={0,2,5,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][52]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][52]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][52]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][52]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][52]={3,1,5,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[71][52]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[72][52]={3,1,-1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[73][52]={0,0,-1,2,{{1,2},{1,3},{0,-1}},{-1,0}}
 MapToConvert[74][52]={0,1,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][52]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][52]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][52]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[78][52]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][52]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][52]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][52]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{1,5}}
 MapToConvert[82][52]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][52]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[84][52]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][52]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{4,5}}
 MapToConvert[86][52]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][52]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][52]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][52]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[93][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][52]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[100][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][52]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][52]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][52]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[116][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[117][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][52]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][52]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][52]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[134][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][52]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][52]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[138][52]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][52]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][52]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][52]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][52]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][53]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][53]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][53]={1,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[6][53]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][53]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][53]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][53]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][53]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[12][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][53]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][53]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][53]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][53]={1,2,-1,3,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][53]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][53]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[20][53]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{18,1}}
 MapToConvert[21][53]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][53]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][53]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][53]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][53]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[34][53]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][53]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][53]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][53]={1,2,-1,4,{{0,-1},{1,3},{0,-1}},{6,1}}
 MapToConvert[39][53]={2,2,4,4,{{1,2},{0,-1},{0,-1}},{26,1}}
 MapToConvert[40][53]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][53]={1,2,-1,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[42][53]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[43][53]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{1,5}}
 MapToConvert[44][53]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][53]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[46][53]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][53]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][53]={2,2,3,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][53]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][53]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[51][53]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][53]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][53]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][53]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][53]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[56][53]={1,2,-1,2,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[57][53]={1,2,-1,2,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[58][53]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[59][53]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][53]={0,2,5,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[61][53]={0,2,-1,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[62][53]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][53]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[64][53]={3,1,-1,2,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[65][53]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{0,5}}
 MapToConvert[66][53]={4,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][53]={4,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][53]={4,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][53]={4,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][53]={4,0,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[71][53]={3,1,-1,2,{{0,-1},{1,3},{0,-1}},{30,1}}
 MapToConvert[72][53]={3,0,-1,2,{{1,2},{1,3},{0,-1}},{-1,0}}
 MapToConvert[73][53]={0,1,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][53]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[75][53]={0,2,5,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[76][53]={0,1,5,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[77][53]={0,1,5,2,{{1,2},{1,0},{1,1}},{2,4}}
 MapToConvert[78][53]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][53]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[80][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][53]={0,2,5,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[82][53]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][53]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][53]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{0,4}}
 MapToConvert[86][53]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][53]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][53]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][53]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[91][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][53]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][53]={1,2,1,1,{{0,-1},{0,-1},{0,-1}},{10,1}}
 MapToConvert[115][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][53]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][53]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][53]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][53]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][53]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{0,4}}
 MapToConvert[139][53]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[140][53]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[149][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][53]={1,2,1,4,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[152][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][53]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][53]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][54]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][54]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][54]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[6][54]={1,1,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[7][54]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][54]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[9][54]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][54]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][54]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][54]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][54]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][54]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][54]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][54]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][54]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][54]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][54]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][54]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{18,1}}
 MapToConvert[24][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[26][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][54]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][54]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[29][54]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][54]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][54]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][54]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[38][54]={0,1,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[39][54]={1,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][54]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][54]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[42][54]={1,2,-1,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[43][54]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][54]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][54]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][54]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[47][54]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][54]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{19,1}}
 MapToConvert[49][54]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][54]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[51][54]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][54]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{4,4}}
 MapToConvert[53][54]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][54]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][54]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][54]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][54]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[58][54]={1,2,-1,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[59][54]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][54]={0,2,-1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[61][54]={0,2,5,2,{{1,2},{1,3},{0,-1}},{-1,0}}
 MapToConvert[62][54]={0,1,5,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][54]={4,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][54]={4,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][54]={4,0,20,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][54]={4,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][54]={4,2,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[68][54]={4,2,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[69][54]={3,2,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[70][54]={3,2,-1,2,{{1,2},{0,-1},{1,1}},{18,1}}
 MapToConvert[71][54]={3,1,-1,2,{{1,2},{1,3},{0,-1}},{-1,0}}
 MapToConvert[72][54]={3,0,-1,2,{{1,2},{1,3},{0,-1}},{-1,0}}
 MapToConvert[73][54]={0,1,5,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][54]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[75][54]={0,2,-1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[76][54]={0,2,-1,2,{{1,2},{0,-1},{0,-1}},{7,1}}
 MapToConvert[77][54]={0,1,-1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[78][54]={0,0,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[79][54]={0,2,-1,2,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[80][54]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][54]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[82][54]={0,2,-1,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[83][54]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][54]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[85][54]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][54]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][54]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][54]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][54]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[91][54]={1,2,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][54]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[94][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][54]={5,3,17,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][54]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][54]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[133][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][54]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][54]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][54]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{2,4}}
 MapToConvert[138][54]={2,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][54]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][54]={1,2,-1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[141][54]={1,2,-1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][54]={1,2,1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[152][54]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][54]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][54]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[4][55]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][55]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[6][55]={1,2,-1,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[7][55]={1,1,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[8][55]={1,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[9][55]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][55]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[11][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][55]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][55]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][55]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][55]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][55]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][55]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][55]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[27][55]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[29][55]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][55]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[32][55]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][55]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][55]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][55]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[36][55]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][55]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][55]={0,2,-1,4,{{0,-1},{1,3},{1,4}},{1,3}}
 MapToConvert[39][55]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][55]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][55]={1,1,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[42][55]={1,1,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][55]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][55]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][55]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[46][55]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][55]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][55]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][55]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[50][55]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][55]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][55]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][55]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][55]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][55]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][55]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][55]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][55]={0,2,-1,2,{{0,-1},{1,3},{1,4}},{6,1}}
 MapToConvert[59][55]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][55]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][55]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][55]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{4,4}}
 MapToConvert[63][55]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][55]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][55]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][55]={4,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][55]={4,1,-1,2,{{0,-1},{0,-1},{0,-1}},{18,1}}
 MapToConvert[68][55]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][55]={4,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][55]={4,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][55]={4,0,-1,2,{{1,2},{1,3},{0,-1}},{-1,0}}
 MapToConvert[72][55]={0,1,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][55]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][55]={0,2,-1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[75][55]={0,1,5,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][55]={0,1,5,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[77][55]={0,1,5,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][55]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][55]={0,2,-1,2,{{0,-1},{1,3},{1,1}},{23,1}}
 MapToConvert[80][55]={0,2,5,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[81][55]={0,2,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[82][55]={0,2,5,2,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[83][55]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[84][55]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][55]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][55]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[88][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][55]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][55]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][55]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][55]={1,1,1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][55]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][55]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][55]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][55]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][55]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][55]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][55]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][55]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][55]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][55]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][55]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][55]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][55]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][55]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][55]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][55]={2,0,-1,1,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[138][55]={1,1,-1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[139][55]={1,2,-1,1,{{1,2},{1,3},{1,1}},{-1,0}}
 MapToConvert[140][55]={1,2,-1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][55]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[142][55]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[143][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][55]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][55]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[146][55]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][55]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[148][55]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][55]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][55]={0,2,2,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[151][55]={0,2,2,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][55]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][55]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][55]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][55]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][55]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][55]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][55]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][56]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][56]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][56]={0,2,-1,4,{{0,-1},{0,-1},{1,4}},{6,1}}
 MapToConvert[5][56]={0,2,-1,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[6][56]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][56]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{15,1}}
 MapToConvert[8][56]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[9][56]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][56]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][56]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][56]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][56]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][56]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][56]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][56]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][56]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][56]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[19][56]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][56]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][56]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][56]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][56]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][56]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[25][56]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][56]={1,2,-1,4,{{0,-1},{0,-1},{1,4}},{26,1}}
 MapToConvert[27][56]={1,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[28][56]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][56]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][56]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][56]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][56]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[33][56]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][56]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{18,1}}
 MapToConvert[35][56]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][56]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][56]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][56]={1,2,-1,4,{{0,-1},{1,3},{0,-1}},{26,1}}
 MapToConvert[39][56]={1,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][56]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][56]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[42][56]={1,0,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][56]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][56]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[45][56]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][56]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][56]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][56]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][56]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][56]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][56]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][56]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{5,3}}
 MapToConvert[53][56]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][56]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[55][56]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][56]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][56]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][56]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][56]={0,1,-1,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[60][56]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][56]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][56]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][56]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][56]={4,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][56]={4,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][56]={4,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][56]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][56]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][56]={4,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][56]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][56]={3,1,-1,2,{{1,2},{0,-1},{1,1}},{18,1}}
 MapToConvert[72][56]={3,1,-1,2,{{1,2},{1,3},{0,-1}},{15,1}}
 MapToConvert[73][56]={3,0,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[74][56]={3,0,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[75][56]={0,1,5,2,{{1,2},{0,-1},{0,-1}},{23,1}}
 MapToConvert[76][56]={1,1,5,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[77][56]={0,1,5,2,{{1,2},{0,-1},{0,-1}},{4,4}}
 MapToConvert[78][56]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][56]={0,0,-1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[80][56]={0,2,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][56]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{2,4}}
 MapToConvert[82][56]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][56]={0,1,5,2,{{0,-1},{1,3},{1,1}},{-1,0}}
 MapToConvert[84][56]={0,2,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[85][56]={0,2,-1,2,{{1,2},{1,0},{1,1}},{6,1}}
 MapToConvert[86][56]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[87][56]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][56]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][56]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][56]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][56]={1,1,1,2,{{1,5},{0,-1},{0,-1}},{12,1}}
 MapToConvert[92][56]={0,2,-1,2,{{0,-1},{0,-1},{1,1}},{6,1}}
 MapToConvert[93][56]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][56]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][56]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[96][56]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][56]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][56]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][56]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][56]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][56]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][56]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][56]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][56]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[133][56]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][56]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[135][56]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[136][56]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][56]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[138][56]={2,2,-1,1,{{0,-1},{1,3},{1,1}},{-1,0}}
 MapToConvert[139][56]={1,2,-1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][56]={1,1,-1,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[141][56]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[142][56]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][56]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][56]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[145][56]={0,2,2,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[146][56]={0,2,2,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][56]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][56]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][56]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][56]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][56]={0,2,-1,4,{{0,-1},{0,-1},{1,1}},{25,1}}
 MapToConvert[152][56]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][56]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][56]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][56]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][56]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][56]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[178][56]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][56]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][57]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][57]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[5][57]={0,1,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[6][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[7][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][57]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{0,4}}
 MapToConvert[10][57]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][57]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][57]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][57]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][57]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][57]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][57]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][57]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][57]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][57]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[20][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[21][57]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{0,5}}
 MapToConvert[22][57]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[23][57]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][57]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][57]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][57]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][57]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{7,1}}
 MapToConvert[28][57]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][57]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][57]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][57]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][57]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[33][57]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[34][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{1,4}}
 MapToConvert[35][57]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][57]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][57]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{18,1}}
 MapToConvert[38][57]={1,1,-1,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[39][57]={1,2,-1,4,{{1,5},{0,-1},{1,4}},{8,1}}
 MapToConvert[40][57]={1,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[41][57]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{2,2}}
 MapToConvert[42][57]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][57]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][57]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][57]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][57]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][57]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][57]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][57]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][57]={2,2,3,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][57]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][57]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][57]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][57]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][57]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][57]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][57]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{4,2}}
 MapToConvert[58][57]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][57]={3,0,-1,2,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[60][57]={3,2,5,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[61][57]={3,0,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[62][57]={3,2,5,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[63][57]={3,2,-1,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[64][57]={3,2,-1,2,{{1,5},{0,-1},{0,-1}},{5,4}}
 MapToConvert[65][57]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][57]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][57]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][57]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][57]={3,2,5,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[70][57]={1,0,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[71][57]={1,0,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[72][57]={1,1,5,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][57]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[74][57]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][57]={1,1,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[76][57]={0,0,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][57]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][57]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][57]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{1,3}}
 MapToConvert[80][57]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][57]={0,2,-1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[82][57]={0,2,-1,2,{{1,2},{0,-1},{1,1}},{33,1}}
 MapToConvert[83][57]={0,2,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][57]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][57]={0,2,-1,2,{{0,-1},{0,-1},{1,1}},{23,1}}
 MapToConvert[86][57]={0,2,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[87][57]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][57]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][57]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{21,1}}
 MapToConvert[90][57]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][57]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][57]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][57]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][57]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][57]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[96][57]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][57]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[98][57]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][57]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][57]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][57]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][57]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][57]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][57]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][57]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][57]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][57]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][57]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][57]={2,1,-1,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[139][57]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][57]={1,2,-1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][57]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][57]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{40,1}}
 MapToConvert[143][57]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][57]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][57]={0,2,2,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[146][57]={0,2,2,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][57]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][57]={0,2,5,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[149][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][57]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][57]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][57]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[154][57]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][57]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][57]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][57]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][57]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{1,3}}
 MapToConvert[179][57]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[4][58]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][58]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][58]={0,2,5,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[7][58]={0,2,5,4,{{1,5},{0,-1},{1,4}},{9,1}}
 MapToConvert[8][58]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[9][58]={0,2,5,4,{{1,5},{0,-1},{1,4}},{26,1}}
 MapToConvert[10][58]={1,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][58]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[13][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][58]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][58]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][58]={0,2,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[21][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][58]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][58]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][58]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][58]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{1,4}}
 MapToConvert[28][58]={1,2,-1,4,{{0,-1},{1,3},{0,-1}},{6,1}}
 MapToConvert[29][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[33][58]={1,1,5,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[34][58]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[35][58]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][58]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[37][58]={1,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[38][58]={0,1,-1,4,{{1,5},{0,-1},{1,4}},{2,3}}
 MapToConvert[39][58]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][58]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[41][58]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][58]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][58]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[44][58]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][58]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[46][58]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][58]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[48][58]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][58]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][58]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][58]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][58]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][58]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[54][58]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][58]={1,1,-1,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[56][58]={3,1,-1,2,{{1,5},{0,-1},{1,4}},{12,1}}
 MapToConvert[57][58]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][58]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][58]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][58]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][58]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][58]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][58]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][58]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][58]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][58]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][58]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][58]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[69][58]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][58]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][58]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][58]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][58]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][58]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][58]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[76][58]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][58]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[78][58]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][58]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][58]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][58]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[82][58]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][58]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][58]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[85][58]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][58]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][58]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][58]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][58]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][58]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][58]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][58]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][58]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{4,5}}
 MapToConvert[94][58]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][58]={0,2,-1,2,{{0,-1},{1,0},{0,-1}},{7,1}}
 MapToConvert[96][58]={1,0,8,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][58]={0,2,-1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[98][58]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[99][58]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][58]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][58]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][58]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][58]={1,1,5,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[133][58]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][58]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][58]={2,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][58]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][58]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][58]={2,0,7,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][58]={1,1,-1,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[140][58]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][58]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[142][58]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][58]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][58]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][58]={0,2,-1,1,{{0,-1},{1,3},{0,-1}},{25,1}}
 MapToConvert[146][58]={0,2,5,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][58]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][58]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][58]={0,2,5,1,{{0,-1},{1,3},{1,4}},{25,1}}
 MapToConvert[150][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][58]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][58]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[153][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][58]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][58]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][58]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][58]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][58]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][58]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][58]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][58]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][59]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][59]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][59]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{0,2}}
 MapToConvert[5][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][59]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][59]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][59]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[10][59]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{1,4}}
 MapToConvert[11][59]={1,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][59]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][59]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][59]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][59]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[16][59]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][59]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[18][59]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[20][59]={1,1,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[21][59]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][59]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][59]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[24][59]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][59]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{0,4}}
 MapToConvert[26][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][59]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[28][59]={0,2,5,4,{{1,2},{1,3},{0,-1}},{-1,0}}
 MapToConvert[29][59]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{8,1}}
 MapToConvert[30][59]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][59]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][59]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[33][59]={0,1,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][59]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][59]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[36][59]={0,1,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[37][59]={0,1,5,4,{{1,5},{0,-1},{0,-1}},{0,4}}
 MapToConvert[38][59]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][59]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][59]={1,0,-1,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[41][59]={1,1,5,4,{{1,5},{0,-1},{0,-1}},{0,2}}
 MapToConvert[42][59]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][59]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{5,5}}
 MapToConvert[44][59]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[45][59]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][59]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][59]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][59]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][59]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][59]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][59]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][59]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[53][59]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][59]={1,1,-1,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[55][59]={3,1,-1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][59]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][59]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][59]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][59]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][59]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[61][59]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][59]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][59]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][59]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][59]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][59]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][59]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][59]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[69][59]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][59]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][59]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{5,5}}
 MapToConvert[72][59]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][59]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{1,4}}
 MapToConvert[74][59]={1,1,5,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[75][59]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][59]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{2,5}}
 MapToConvert[77][59]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][59]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][59]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][59]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][59]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[82][59]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][59]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[84][59]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][59]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][59]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][59]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][59]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][59]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][59]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[91][59]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][59]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][59]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][59]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][59]={0,1,5,2,{{0,-1},{1,0},{1,1}},{17,1}}
 MapToConvert[96][59]={0,1,-1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[97][59]={0,2,5,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][59]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][59]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][59]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][59]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[131][59]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[132][59]={1,2,-1,1,{{0,-1},{1,3},{1,4}},{6,1}}
 MapToConvert[133][59]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][59]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[135][59]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][59]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][59]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][59]={2,1,-1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[139][59]={1,1,-1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][59]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[141][59]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][59]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][59]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][59]={0,2,-1,1,{{0,-1},{1,3},{0,-1}},{6,1}}
 MapToConvert[145][59]={0,2,5,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][59]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[147][59]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][59]={0,1,5,1,{{0,-1},{1,3},{0,-1}},{18,1}}
 MapToConvert[149][59]={0,1,5,1,{{1,2},{1,3},{1,4}},{-1,0}}
 MapToConvert[150][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[151][59]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][59]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][59]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][59]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][59]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][59]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][59]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][59]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][60]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][60]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[6][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][60]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][60]={0,1,5,4,{{0,-1},{0,-1},{1,1}},{2,4}}
 MapToConvert[9][60]={0,1,5,4,{{1,2},{0,-1},{1,1}},{4,3}}
 MapToConvert[10][60]={0,0,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][60]={1,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][60]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][60]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][60]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[17][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][60]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{1,5}}
 MapToConvert[20][60]={1,1,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[21][60]={1,2,-1,4,{{1,2},{0,-1},{0,-1}},{7,1}}
 MapToConvert[22][60]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][60]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][60]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{18,1}}
 MapToConvert[25][60]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][60]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][60]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[28][60]={0,1,-1,4,{{1,2},{1,3},{0,-1}},{-1,0}}
 MapToConvert[29][60]={0,1,-1,4,{{1,2},{0,-1},{0,-1}},{30,1}}
 MapToConvert[30][60]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][60]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[34][60]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][60]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][60]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][60]={1,2,-1,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[38][60]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[40][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][60]={0,2,-1,4,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[42][60]={0,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[43][60]={0,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[44][60]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{8,1}}
 MapToConvert[45][60]={1,2,-1,4,{{1,2},{0,-1},{0,-1}},{6,1}}
 MapToConvert[46][60]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][60]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][60]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][60]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][60]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][60]={2,2,-1,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[52][60]={2,2,4,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[53][60]={2,2,4,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[54][60]={1,2,-1,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[55][60]={1,1,-1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][60]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[57][60]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][60]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{5,3}}
 MapToConvert[59][60]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][60]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][60]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][60]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][60]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][60]={2,2,3,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][60]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[66][60]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][60]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][60]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][60]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][60]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][60]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][60]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][60]={1,2,-1,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[74][60]={1,1,-1,2,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[75][60]={1,2,-1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][60]={1,2,5,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[77][60]={1,1,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[78][60]={1,2,5,2,{{1,2},{1,3},{1,1}},{-1,0}}
 MapToConvert[79][60]={1,2,-1,2,{{1,2},{1,3},{1,1}},{7,1}}
 MapToConvert[80][60]={1,0,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[81][60]={1,1,-1,2,{{1,2},{1,0},{1,1}},{23,1}}
 MapToConvert[82][60]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][60]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][60]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][60]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[86][60]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][60]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][60]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][60]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][60]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][60]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[92][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][60]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][60]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[95][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][60]={0,0,-1,2,{{1,5},{1,3},{0,-1}},{-1,0}}
 MapToConvert[97][60]={0,1,5,2,{{1,2},{0,-1},{0,-1}},{2,4}}
 MapToConvert[98][60]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{1,5}}
 MapToConvert[99][60]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][60]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[101][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][60]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][60]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][60]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][60]={1,1,5,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[133][60]={1,2,-1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][60]={2,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][60]={2,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][60]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][60]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][60]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][60]={1,1,-1,1,{{0,-1},{1,3},{1,4}},{15,1}}
 MapToConvert[140][60]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][60]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][60]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][60]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[144][60]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][60]={0,2,-1,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[146][60]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][60]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][60]={0,2,5,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[149][60]={0,1,5,1,{{1,2},{1,3},{0,-1}},{-1,0}}
 MapToConvert[150][60]={0,0,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][60]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[152][60]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][60]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[154][60]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][60]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][60]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][60]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][61]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[5][61]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][61]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][61]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][61]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][61]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][61]={0,1,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[11][61]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][61]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][61]={1,2,-1,4,{{0,-1},{1,3},{0,-1}},{6,1}}
 MapToConvert[14][61]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][61]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[16][61]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][61]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][61]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][61]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[20][61]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{26,1}}
 MapToConvert[21][61]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][61]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][61]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][61]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][61]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{0,2}}
 MapToConvert[26][61]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][61]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][61]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{2,4}}
 MapToConvert[29][61]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][61]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{1,3}}
 MapToConvert[31][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][61]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][61]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][61]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[36][61]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][61]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][61]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][61]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][61]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{2,2}}
 MapToConvert[42][61]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][61]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][61]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][61]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][61]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][61]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][61]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[50][61]={2,2,4,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[51][61]={2,2,4,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][61]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][61]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][61]={1,2,-1,2,{{0,-1},{1,0},{0,-1}},{31,1}}
 MapToConvert[55][61]={1,2,-1,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[56][61]={3,1,-1,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[57][61]={1,2,-1,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[58][61]={3,0,-1,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[59][61]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][61]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][61]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][61]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{15,1}}
 MapToConvert[63][61]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][61]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][61]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[66][61]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][61]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][61]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][61]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][61]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[71][61]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][61]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[73][61]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[74][61]={1,1,-1,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[75][61]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][61]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[77][61]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][61]={1,2,5,2,{{1,2},{1,3},{0,-1}},{-1,0}}
 MapToConvert[79][61]={1,0,-1,2,{{1,2},{1,3},{1,4}},{-1,0}}
 MapToConvert[80][61]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[81][61]={1,2,-1,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[82][61]={0,2,-1,2,{{1,2},{1,0},{1,1}},{6,1}}
 MapToConvert[83][61]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][61]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][61]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][61]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][61]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][61]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[89][61]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[90][61]={0,1,5,2,{{0,-1},{1,0},{0,-1}},{0,3}}
 MapToConvert[91][61]={0,1,5,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][61]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][61]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][61]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][61]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][61]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][61]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][61]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][61]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][61]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][61]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][61]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{26,1}}
 MapToConvert[132][61]={1,1,-1,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[133][61]={2,2,4,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][61]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][61]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][61]={2,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][61]={2,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][61]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][61]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][61]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][61]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][61]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][61]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][61]={0,2,-1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[145][61]={0,2,-1,1,{{1,2},{1,3},{1,4}},{-1,0}}
 MapToConvert[146][61]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][61]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][61]={0,1,5,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[149][61]={0,1,5,1,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[150][61]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][61]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{2,3}}
 MapToConvert[152][61]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][61]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{40,1}}
 MapToConvert[154][61]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][61]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][61]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][61]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[10][62]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[11][62]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{26,1}}
 MapToConvert[12][62]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][62]={0,1,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[14][62]={0,2,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[15][62]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][62]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][62]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][62]={1,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[19][62]={1,2,-1,4,{{1,2},{0,-1},{1,1}},{6,1}}
 MapToConvert[20][62]={1,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[21][62]={0,2,2,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][62]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{2,3}}
 MapToConvert[24][62]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][62]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{4,4}}
 MapToConvert[26][62]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[27][62]={0,1,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[28][62]={0,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[29][62]={0,2,5,4,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[30][62]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][62]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][62]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][62]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][62]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][62]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][62]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][62]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][62]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][62]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{4,4}}
 MapToConvert[44][62]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[46][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][62]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][62]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][62]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][62]={2,2,4,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[51][62]={2,2,-1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][62]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[53][62]={2,2,-1,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[54][62]={2,2,4,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[55][62]={1,2,-1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][62]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][62]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[58][62]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][62]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][62]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{0,5}}
 MapToConvert[61][62]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][62]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][62]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][62]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][62]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][62]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[67][62]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][62]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][62]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{2,4}}
 MapToConvert[70][62]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][62]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][62]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][62]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][62]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][62]={1,2,-1,2,{{0,-1},{1,0},{1,1}},{7,1}}
 MapToConvert[76][62]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][62]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][62]={1,1,-1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[79][62]={1,2,-1,2,{{1,2},{0,-1},{0,-1}},{23,1}}
 MapToConvert[80][62]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][62]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][62]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][62]={0,2,-1,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[84][62]={0,2,-1,2,{{1,2},{0,-1},{1,1}},{23,1}}
 MapToConvert[85][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][62]={0,2,-1,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[90][62]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][62]={0,1,5,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[92][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[94][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][62]={0,1,5,2,{{0,-1},{1,0},{0,-1}},{0,5}}
 MapToConvert[98][62]={0,1,-1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][62]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][62]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][62]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{34,1}}
 MapToConvert[132][62]={1,1,5,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[133][62]={2,2,4,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][62]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[135][62]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][62]={2,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][62]={2,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][62]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][62]={1,0,9,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][62]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][62]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][62]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[143][62]={0,1,-1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[144][62]={0,2,-1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[145][62]={0,2,5,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][62]={0,2,-1,1,{{0,-1},{1,3},{1,4}},{6,1}}
 MapToConvert[147][62]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[148][62]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][62]={0,1,5,1,{{0,-1},{0,-1},{1,4}},{12,1}}
 MapToConvert[150][62]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][62]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][62]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][62]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][62]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][62]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{1,5}}
 MapToConvert[156][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][62]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][62]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][63]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][63]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][63]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][63]={1,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][63]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{4,5}}
 MapToConvert[12][63]={0,1,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[13][63]={0,1,5,4,{{1,5},{0,-1},{0,-1}},{12,1}}
 MapToConvert[14][63]={0,2,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[15][63]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{5,4}}
 MapToConvert[16][63]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][63]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][63]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[19][63]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][63]={1,1,-1,4,{{0,-1},{0,-1},{0,-1}},{0,4}}
 MapToConvert[21][63]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][63]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][63]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][63]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][63]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[26][63]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{6,1}}
 MapToConvert[27][63]={0,1,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][63]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][63]={0,2,5,4,{{0,-1},{0,-1},{1,1}},{33,1}}
 MapToConvert[30][63]={0,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[31][63]={0,2,-1,4,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[32][63]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][63]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][63]={1,1,5,4,{{0,-1},{0,-1},{0,-1}},{4,2}}
 MapToConvert[41][63]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[42][63]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][63]={2,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][63]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][63]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][63]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][63]={2,2,-1,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[50][63]={2,2,4,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][63]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][63]={2,2,4,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[53][63]={2,2,4,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][63]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][63]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[56][63]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][63]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][63]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][63]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][63]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][63]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][63]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][63]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[64][63]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][63]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][63]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][63]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][63]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][63]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][63]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][63]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][63]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{18,1}}
 MapToConvert[73][63]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][63]={2,2,3,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][63]={1,2,-1,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[76][63]={2,2,4,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[77][63]={1,2,-1,2,{{1,2},{0,-1},{1,1}},{25,1}}
 MapToConvert[78][63]={1,1,5,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][63]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][63]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][63]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[82][63]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][63]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[86][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][63]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][63]={0,2,-1,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[90][63]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[91][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,2}}
 MapToConvert[96][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][63]={0,1,5,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[98][63]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[129][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][63]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][63]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][63]={1,1,-1,1,{{0,-1},{0,-1},{1,4}},{0,4}}
 MapToConvert[133][63]={2,1,-1,1,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[134][63]={2,2,4,1,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[135][63]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[136][63]={2,2,4,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][63]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][63]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][63]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][63]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[141][63]={1,2,-1,1,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[142][63]={1,1,5,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[143][63]={0,1,-1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][63]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][63]={0,2,-1,1,{{0,-1},{1,3},{0,-1}},{3,4}}
 MapToConvert[146][63]={0,2,-1,1,{{1,2},{0,-1},{1,4}},{6,1}}
 MapToConvert[147][63]={0,2,-1,1,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[148][63]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][63]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][63]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{4,4}}
 MapToConvert[151][63]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][63]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{2,4}}
 MapToConvert[153][63]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][63]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][63]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[156][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][63]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][63]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][63]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][63]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][63]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][64]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][64]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][64]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][64]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][64]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[9][64]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][64]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][64]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{26,1}}
 MapToConvert[12][64]={0,1,5,4,{{1,5},{0,-1},{1,4}},{0,4}}
 MapToConvert[13][64]={0,1,5,4,{{1,5},{0,-1},{0,-1}},{2,4}}
 MapToConvert[14][64]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][64]={0,2,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[16][64]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][64]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][64]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][64]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][64]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][64]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][64]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][64]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][64]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{1,2}}
 MapToConvert[25][64]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[26][64]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][64]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{1,4}}
 MapToConvert[28][64]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][64]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][64]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{5,2}}
 MapToConvert[31][64]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][64]={0,1,-1,4,{{0,-1},{0,-1},{1,1}},{31,1}}
 MapToConvert[33][64]={0,2,2,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][64]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][64]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[36][64]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[37][64]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][64]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][64]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][64]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][64]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][64]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][64]={2,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][64]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[45][64]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][64]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][64]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][64]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][64]={2,2,-1,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[50][64]={2,2,4,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][64]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][64]={2,2,4,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[53][64]={2,2,-1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][64]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][64]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][64]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][64]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[58][64]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][64]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[60][64]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][64]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[62][64]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][64]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][64]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][64]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][64]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][64]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][64]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[69][64]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][64]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[71][64]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][64]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[73][64]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][64]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][64]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][64]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][64]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][64]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][64]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][64]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][64]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[82][64]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[83][64]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][64]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{1,5}}
 MapToConvert[85][64]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][64]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][64]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][64]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][64]={0,2,-1,2,{{1,5},{1,3},{1,4}},{6,1}}
 MapToConvert[90][64]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][64]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][64]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][64]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{14,1}}
 MapToConvert[94][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][64]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][64]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][64]={0,1,5,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[98][64]={0,2,-1,2,{{1,5},{0,-1},{0,-1}},{23,1}}
 MapToConvert[99][64]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][64]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][64]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][64]={0,2,-1,1,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[131][64]={1,1,5,1,{{1,5},{1,3},{1,4}},{4,4}}
 MapToConvert[132][64]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[133][64]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][64]={2,2,3,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][64]={2,2,4,1,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[136][64]={2,1,-1,1,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[137][64]={1,0,-1,1,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[138][64]={1,1,5,1,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[139][64]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[140][64]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][64]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][64]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][64]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][64]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[145][64]={0,2,-1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[146][64]={0,2,-1,1,{{1,2},{0,-1},{0,-1}},{6,1}}
 MapToConvert[147][64]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[148][64]={0,2,-1,1,{{0,-1},{0,-1},{1,4}},{6,1}}
 MapToConvert[149][64]={0,2,-1,1,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[150][64]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[151][64]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][64]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][64]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[154][64]={0,2,5,4,{{1,2},{1,0},{1,1}},{9,1}}
 MapToConvert[155][64]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][64]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][64]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][64]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][64]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][64]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][64]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][64]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][64]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][65]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][65]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][65]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][65]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][65]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][65]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][65]={0,2,5,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[10][65]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[11][65]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][65]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][65]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][65]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{1,5}}
 MapToConvert[15][65]={0,2,-1,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[16][65]={0,2,5,4,{{1,5},{0,-1},{1,4}},{9,1}}
 MapToConvert[17][65]={0,1,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[18][65]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][65]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[20][65]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][65]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][65]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[23][65]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][65]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][65]={0,2,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[26][65]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][65]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][65]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][65]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][65]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][65]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][65]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[33][65]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][65]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][65]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][65]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[37][65]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[38][65]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][65]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][65]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[41][65]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][65]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][65]={2,2,4,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][65]={2,2,4,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][65]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][65]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[47][65]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][65]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][65]={2,2,-1,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[50][65]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][65]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[52][65]={2,2,-1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][65]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][65]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][65]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][65]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[57][65]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][65]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][65]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][65]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][65]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][65]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[63][65]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][65]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][65]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[66][65]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][65]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][65]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][65]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][65]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][65]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[72][65]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][65]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][65]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][65]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][65]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][65]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{2,3}}
 MapToConvert[78][65]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][65]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[80][65]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][65]={1,1,-1,2,{{1,2},{1,3},{1,1}},{-1,0}}
 MapToConvert[82][65]={1,2,-1,2,{{1,2},{0,-1},{1,1}},{6,1}}
 MapToConvert[83][65]={1,2,5,2,{{1,2},{1,3},{1,1}},{-1,0}}
 MapToConvert[84][65]={1,1,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][65]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][65]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][65]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{4,4}}
 MapToConvert[88][65]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][65]={0,2,5,2,{{0,-1},{1,3},{1,4}},{23,1}}
 MapToConvert[90][65]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][65]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{1,5}}
 MapToConvert[92][65]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][65]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][65]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][65]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][65]={0,2,5,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[98][65]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][65]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[100][65]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][65]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][65]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][65]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][65]={0,1,-1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[131][65]={1,2,-1,1,{{1,2},{0,-1},{0,-1}},{40,1}}
 MapToConvert[132][65]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][65]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][65]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][65]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][65]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{5,5}}
 MapToConvert[137][65]={1,0,-1,1,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[138][65]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][65]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][65]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][65]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{40,1}}
 MapToConvert[142][65]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][65]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][65]={0,2,2,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[145][65]={0,2,2,1,{{1,2},{1,3},{1,4}},{-1,0}}
 MapToConvert[146][65]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][65]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][65]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][65]={0,2,-1,1,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[150][65]={0,2,5,1,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[151][65]={0,2,5,1,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[152][65]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][65]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][65]={0,1,-1,4,{{0,-1},{0,-1},{1,1}},{30,1}}
 MapToConvert[155][65]={0,1,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][65]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][65]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][65]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][65]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][65]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][65]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][65]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][65]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][65]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][66]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][66]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][66]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][66]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][66]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][66]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][66]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[10][66]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][66]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][66]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][66]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{6,1}}
 MapToConvert[14][66]={0,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[15][66]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][66]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{26,1}}
 MapToConvert[17][66]={0,1,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[18][66]={0,1,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][66]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][66]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[21][66]={0,1,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[22][66]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[23][66]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{8,1}}
 MapToConvert[24][66]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[25][66]={0,1,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[26][66]={0,1,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][66]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][66]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][66]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[30][66]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][66]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][66]={1,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[33][66]={1,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[34][66]={1,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][66]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[36][66]={1,2,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[37][66]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[38][66]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][66]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][66]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][66]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[42][66]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[43][66]={1,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[44][66]={2,2,4,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[45][66]={2,2,4,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][66]={2,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][66]={2,2,4,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[48][66]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][66]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][66]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][66]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][66]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][66]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][66]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][66]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][66]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][66]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][66]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][66]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][66]={2,2,3,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][66]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][66]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][66]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][66]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][66]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][66]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][66]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{1,1}}
 MapToConvert[68][66]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][66]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][66]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][66]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][66]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][66]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][66]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[75][66]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][66]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][66]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][66]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][66]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][66]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{27,1}}
 MapToConvert[81][66]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][66]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][66]={1,1,-1,2,{{0,-1},{1,3},{0,-1}},{0,4}}
 MapToConvert[84][66]={1,2,5,2,{{1,2},{0,-1},{0,-1}},{9,1}}
 MapToConvert[85][66]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][66]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{23,1}}
 MapToConvert[87][66]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][66]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{25,1}}
 MapToConvert[89][66]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][66]={3,1,5,2,{{0,-1},{1,3},{1,4}},{0,4}}
 MapToConvert[91][66]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][66]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][66]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][66]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][66]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][66]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[97][66]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][66]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][66]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][66]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][66]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][66]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][66]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][66]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][66]={1,2,5,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[132][66]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][66]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][66]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[135][66]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][66]={1,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][66]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][66]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][66]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][66]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][66]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][66]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][66]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][66]={0,2,-1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[145][66]={0,2,-1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][66]={0,2,-1,1,{{0,-1},{1,3},{1,4}},{3,3}}
 MapToConvert[147][66]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][66]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][66]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[150][66]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][66]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][66]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][66]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[154][66]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][66]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][66]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][66]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[158][66]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][66]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][66]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][66]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][66]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][66]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][66]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][67]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][67]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][67]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][67]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][67]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][67]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][67]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][67]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][67]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[11][67]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][67]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{7,1}}
 MapToConvert[13][67]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][67]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][67]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][67]={0,1,5,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[17][67]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[18][67]={0,1,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[19][67]={0,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[20][67]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{7,1}}
 MapToConvert[21][67]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][67]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][67]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][67]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][67]={0,1,5,4,{{0,-1},{1,0},{0,-1}},{0,3}}
 MapToConvert[26][67]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][67]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][67]={0,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][67]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][67]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{0,2}}
 MapToConvert[31][67]={0,1,-1,4,{{0,-1},{1,3},{0,-1}},{12,1}}
 MapToConvert[32][67]={1,2,-1,4,{{1,2},{0,-1},{0,-1}},{6,1}}
 MapToConvert[33][67]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][67]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][67]={1,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[36][67]={1,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][67]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[38][67]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[39][67]={1,2,-1,4,{{0,-1},{1,3},{1,4}},{6,1}}
 MapToConvert[40][67]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][67]={1,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[42][67]={1,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[43][67]={1,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][67]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][67]={2,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][67]={2,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[47][67]={2,2,4,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][67]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][67]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][67]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][67]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][67]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][67]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[54][67]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][67]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][67]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][67]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][67]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][67]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][67]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][67]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][67]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][67]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][67]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][67]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[66][67]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][67]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][67]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[69][67]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][67]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][67]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{15,1}}
 MapToConvert[72][67]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][67]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][67]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][67]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][67]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][67]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][67]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][67]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][67]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][67]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][67]={2,2,3,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][67]={1,1,-1,2,{{1,2},{1,3},{1,4}},{-1,0}}
 MapToConvert[84][67]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][67]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][67]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[87][67]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][67]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][67]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{2,5}}
 MapToConvert[90][67]={3,0,-1,2,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[91][67]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][67]={0,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][67]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][67]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[95][67]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][67]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][67]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][67]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][67]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][67]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][67]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][67]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[129][67]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][67]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[131][67]={1,2,-1,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[132][67]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][67]={2,1,-1,1,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[134][67]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][67]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][67]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{0,4}}
 MapToConvert[137][67]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[138][67]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][67]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[140][67]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][67]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{2,4}}
 MapToConvert[142][67]={1,2,-1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[143][67]={1,2,-1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[144][67]={0,2,5,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][67]={0,2,5,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[146][67]={0,2,5,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][67]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][67]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][67]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][67]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][67]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][67]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][67]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][67]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{0,5}}
 MapToConvert[155][67]={0,1,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[156][67]={0,2,-1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][67]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[158][67]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][67]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][67]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][67]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][67]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][67]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][67]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][67]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][67]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][68]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][68]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][68]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][68]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][68]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][68]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][68]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][68]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][68]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][68]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][68]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{3,4}}
 MapToConvert[13][68]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][68]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][68]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[16][68]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][68]={0,1,5,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[18][68]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][68]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{2,5}}
 MapToConvert[20][68]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][68]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[22][68]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][68]={0,1,-1,4,{{0,-1},{1,0},{0,-1}},{0,4}}
 MapToConvert[24][68]={0,1,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][68]={0,1,5,4,{{0,-1},{1,0},{1,1}},{4,5}}
 MapToConvert[26][68]={0,2,5,4,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[27][68]={0,2,5,4,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[28][68]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[29][68]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[30][68]={0,2,5,4,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[31][68]={0,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[32][68]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][68]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{33,1}}
 MapToConvert[34][68]={1,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[35][68]={1,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[36][68]={1,2,-1,4,{{1,2},{0,-1},{0,-1}},{5,3}}
 MapToConvert[37][68]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][68]={1,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[39][68]={1,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[40][68]={1,2,5,4,{{1,2},{1,3},{0,-1}},{-1,0}}
 MapToConvert[41][68]={1,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[42][68]={1,2,-1,4,{{1,2},{0,-1},{0,-1}},{1,4}}
 MapToConvert[43][68]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][68]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][68]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[46][68]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][68]={1,2,-1,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[48][68]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][68]={2,2,4,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][68]={2,2,4,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][68]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][68]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][68]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][68]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][68]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][68]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][68]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][68]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][68]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][68]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][68]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][68]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][68]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][68]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[65][68]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][68]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][68]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][68]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][68]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][68]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][68]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][68]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][68]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][68]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][68]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][68]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][68]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[78][68]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][68]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][68]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][68]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[82][68]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][68]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][68]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][68]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[86][68]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][68]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][68]={0,2,5,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[89][68]={0,2,5,2,{{1,5},{0,-1},{0,-1}},{9,1}}
 MapToConvert[90][68]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][68]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[92][68]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][68]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][68]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][68]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][68]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][68]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[98][68]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][68]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[100][68]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][68]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][68]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][68]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][68]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][68]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][68]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][68]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][68]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][68]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][68]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][68]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][68]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][68]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][68]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][68]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][68]={1,2,-1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[143][68]={1,2,5,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][68]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][68]={0,2,5,1,{{0,-1},{1,3},{0,-1}},{9,1}}
 MapToConvert[146][68]={0,2,5,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][68]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][68]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[149][68]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[150][68]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][68]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][68]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][68]={0,2,-1,1,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[154][68]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][68]={0,2,5,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[156][68]={0,1,-1,1,{{1,2},{0,-1},{0,-1}},{4,3}}
 MapToConvert[157][68]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][68]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][68]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][68]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][68]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][68]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[163][68]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][68]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][68]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][68]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][68]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][68]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][68]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][69]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][69]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][69]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][69]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][69]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][69]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][69]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][69]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][69]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[10][69]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][69]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][69]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][69]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][69]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[15][69]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][69]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[17][69]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{9,1}}
 MapToConvert[18][69]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{2,4}}
 MapToConvert[19][69]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][69]={0,1,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[21][69]={0,1,5,4,{{1,5},{0,-1},{1,4}},{30,1}}
 MapToConvert[22][69]={0,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[23][69]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{9,1}}
 MapToConvert[24][69]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[25][69]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][69]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[27][69]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][69]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][69]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][69]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[31][69]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][69]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[33][69]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][69]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[35][69]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[36][69]={1,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[37][69]={1,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[38][69]={1,2,-1,4,{{1,2},{0,-1},{0,-1}},{6,1}}
 MapToConvert[39][69]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[40][69]={1,2,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[41][69]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][69]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][69]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[44][69]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][69]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{2,3}}
 MapToConvert[46][69]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][69]={0,2,-1,4,{{0,-1},{0,-1},{1,4}},{7,1}}
 MapToConvert[48][69]={1,1,-1,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[49][69]={1,1,-1,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[50][69]={1,2,-1,2,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[51][69]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[52][69]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][69]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][69]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][69]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][69]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][69]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][69]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[59][69]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][69]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][69]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][69]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][69]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][69]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][69]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][69]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[67][69]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][69]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][69]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{3,2}}
 MapToConvert[70][69]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][69]={2,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][69]={2,2,3,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][69]={2,1,-1,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[74][69]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[75][69]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][69]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][69]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][69]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][69]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{1,4}}
 MapToConvert[80][69]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][69]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][69]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][69]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][69]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][69]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][69]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][69]={0,1,5,2,{{0,-1},{1,0},{0,-1}},{30,1}}
 MapToConvert[88][69]={0,1,5,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][69]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][69]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][69]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][69]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][69]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][69]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][69]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][69]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][69]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][69]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][69]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[100][69]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][69]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][69]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][69]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][69]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][69]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][69]={0,1,5,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[132][69]={3,2,5,1,{{1,5},{0,-1},{1,4}},{20,1}}
 MapToConvert[133][69]={3,2,-1,1,{{1,5},{0,-1},{1,4}},{1,5}}
 MapToConvert[134][69]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][69]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][69]={1,0,13,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][69]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][69]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][69]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[140][69]={1,2,-1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[141][69]={1,2,-1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[142][69]={0,2,-1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][69]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[144][69]={0,2,5,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[145][69]={0,2,5,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][69]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[147][69]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][69]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][69]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][69]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][69]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][69]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[153][69]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[154][69]={1,2,-1,1,{{0,-1},{1,0},{1,1}},{1,4}}
 MapToConvert[155][69]={0,2,5,1,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[156][69]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][69]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[158][69]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][69]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][69]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][69]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][69]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][69]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][69]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][69]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][69]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][69]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][69]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][69]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][70]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][70]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][70]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][70]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][70]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][70]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][70]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[8][70]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[9][70]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][70]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][70]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][70]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][70]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][70]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][70]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[16][70]={0,2,2,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[17][70]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][70]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][70]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[20][70]={0,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[21][70]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][70]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][70]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][70]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{8,1}}
 MapToConvert[25][70]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][70]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{33,1}}
 MapToConvert[27][70]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{3,5}}
 MapToConvert[28][70]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][70]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][70]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][70]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][70]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][70]={0,2,-1,4,{{0,-1},{1,3},{1,4}},{7,1}}
 MapToConvert[34][70]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][70]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][70]={1,2,-1,4,{{0,-1},{1,3},{0,-1}},{6,1}}
 MapToConvert[37][70]={1,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][70]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][70]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[40][70]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[41][70]={1,2,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[42][70]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][70]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][70]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][70]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][70]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][70]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][70]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][70]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[50][70]={1,1,-1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[51][70]={1,1,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][70]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][70]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][70]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][70]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][70]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][70]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][70]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][70]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][70]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][70]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][70]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][70]={2,2,-1,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[64][70]={2,1,-1,2,{{1,5},{0,-1},{1,4}},{12,1}}
 MapToConvert[65][70]={1,2,-1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][70]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][70]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][70]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][70]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][70]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][70]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][70]={3,0,-1,2,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[73][70]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][70]={1,2,-1,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[75][70]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][70]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{1,3}}
 MapToConvert[77][70]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][70]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][70]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][70]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[81][70]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][70]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][70]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[84][70]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][70]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][70]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{2,3}}
 MapToConvert[87][70]={1,2,-1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[88][70]={0,2,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[89][70]={0,2,-1,2,{{1,2},{0,-1},{1,1}},{33,1}}
 MapToConvert[90][70]={0,2,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[91][70]={0,2,-1,2,{{1,2},{1,0},{1,1}},{23,1}}
 MapToConvert[92][70]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[93][70]={1,2,5,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[94][70]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][70]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[96][70]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][70]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][70]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][70]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][70]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][70]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][70]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][70]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][70]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][70]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][70]={3,2,-1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[132][70]={3,2,-1,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][70]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][70]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[135][70]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][70]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{15,1}}
 MapToConvert[137][70]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][70]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][70]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][70]={1,2,-1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[141][70]={1,2,-1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][70]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[143][70]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][70]={0,2,5,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[145][70]={0,2,5,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][70]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][70]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][70]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][70]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][70]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[151][70]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][70]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][70]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][70]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[155][70]={0,2,-1,1,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[156][70]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[157][70]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][70]={0,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][70]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][70]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][70]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[162][70]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][70]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][70]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][70]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][70]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][70]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][70]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][70]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][70]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][70]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][71]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][71]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][71]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][71]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][71]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][71]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[7][71]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][71]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][71]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][71]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[12][71]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][71]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][71]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][71]={0,2,2,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[16][71]={0,2,2,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][71]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[18][71]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[19][71]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{33,1}}
 MapToConvert[20][71]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{0,4}}
 MapToConvert[21][71]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][71]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[23][71]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[24][71]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][71]={0,1,5,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[27][71]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][71]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[29][71]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][71]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[32][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][71]={0,1,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[34][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][71]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{9,1}}
 MapToConvert[41][71]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[46][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][71]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][71]={0,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][71]={3,1,-1,2,{{0,-1},{1,3},{1,4}},{0,5}}
 MapToConvert[51][71]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][71]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][71]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][71]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[55][71]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][71]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][71]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][71]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[59][71]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][71]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][71]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][71]={2,2,-1,2,{{0,-1},{1,0},{0,-1}},{3,3}}
 MapToConvert[63][71]={2,2,-1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][71]={2,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][71]={1,2,-1,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[66][71]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][71]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][71]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][71]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][71]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][71]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][71]={1,2,-1,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[73][71]={1,2,-1,2,{{1,2},{0,-1},{1,1}},{5,4}}
 MapToConvert[74][71]={1,1,-1,2,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[75][71]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][71]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[77][71]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][71]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][71]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][71]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][71]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{3,2}}
 MapToConvert[82][71]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][71]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][71]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][71]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][71]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][71]={1,2,-1,2,{{0,-1},{1,3},{1,4}},{3,4}}
 MapToConvert[88][71]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][71]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][71]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[91][71]={0,2,5,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[92][71]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{5,3}}
 MapToConvert[93][71]={3,2,5,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[94][71]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][71]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][71]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][71]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][71]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[99][71]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][71]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][71]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][71]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][71]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][71]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][71]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][71]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][71]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[131][71]={3,0,-1,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][71]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[133][71]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][71]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][71]={1,1,5,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[136][71]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][71]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[138][71]={1,2,-1,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[139][71]={1,2,5,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[140][71]={0,2,5,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][71]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][71]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][71]={0,2,5,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[144][71]={0,2,5,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][71]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][71]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][71]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[148][71]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][71]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][71]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][71]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][71]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][71]={0,2,5,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[154][71]={0,2,5,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[155][71]={0,1,-1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[156][71]={0,1,-1,1,{{1,2},{1,0},{1,1}},{30,1}}
 MapToConvert[157][71]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][71]={0,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][71]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][71]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][71]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][71]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][71]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][71]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][71]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][71]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[167][71]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][71]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][71]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][71]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][71]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][72]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][72]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][72]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][72]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][72]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][72]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][72]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][72]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][72]={0,2,-1,4,{{0,-1},{0,-1},{1,1}},{6,1}}
 MapToConvert[11][72]={0,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[12][72]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[13][72]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[14][72]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][72]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][72]={0,2,-1,4,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[17][72]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][72]={0,2,2,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[19][72]={0,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][72]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][72]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{1,4}}
 MapToConvert[22][72]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][72]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{5,4}}
 MapToConvert[24][72]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][72]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][72]={0,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[27][72]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{6,1}}
 MapToConvert[28][72]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][72]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][72]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][72]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][72]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][72]={0,1,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[34][72]={0,2,-1,4,{{1,2},{0,-1},{0,-1}},{2,4}}
 MapToConvert[35][72]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{0,4}}
 MapToConvert[36][72]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[37][72]={0,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[38][72]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{1,5}}
 MapToConvert[39][72]={0,2,-1,4,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[40][72]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[41][72]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][72]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[43][72]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][72]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][72]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][72]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][72]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][72]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][72]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][72]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{2,4}}
 MapToConvert[51][72]={3,0,-1,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[52][72]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][72]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[54][72]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][72]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][72]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][72]={0,2,-1,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[58][72]={0,2,-1,2,{{1,5},{0,-1},{1,4}},{6,1}}
 MapToConvert[59][72]={1,2,-1,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[60][72]={1,2,-1,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[61][72]={1,2,-1,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[62][72]={1,2,-1,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[63][72]={1,2,-1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][72]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[65][72]={1,2,-1,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[66][72]={3,0,-1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][72]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[68][72]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][72]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][72]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][72]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][72]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[73][72]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][72]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][72]={1,1,5,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[76][72]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][72]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][72]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[79][72]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][72]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][72]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][72]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][72]={3,1,5,2,{{0,-1},{1,0},{0,-1}},{4,4}}
 MapToConvert[84][72]={3,1,5,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[85][72]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][72]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][72]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[88][72]={1,2,-1,2,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[89][72]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][72]={0,1,-1,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[91][72]={0,2,5,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[92][72]={0,2,5,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[93][72]={0,2,-1,2,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[94][72]={3,0,-1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][72]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[96][72]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][72]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[98][72]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][72]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][72]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][72]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][72]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[103][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][72]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][72]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][72]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][72]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][72]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][72]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][72]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][72]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][72]={3,0,-1,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[132][72]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][72]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][72]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][72]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[136][72]={1,2,-1,1,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[137][72]={1,2,-1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[138][72]={1,2,5,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[139][72]={0,2,5,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][72]={0,2,-1,1,{{0,-1},{0,-1},{0,-1}},{40,1}}
 MapToConvert[141][72]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][72]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][72]={3,2,5,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[144][72]={3,2,5,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][72]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][72]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][72]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[148][72]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][72]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][72]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[151][72]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][72]={3,2,5,1,{{1,2},{1,3},{1,1}},{-1,0}}
 MapToConvert[153][72]={3,1,5,1,{{1,2},{0,-1},{1,1}},{0,4}}
 MapToConvert[154][72]={3,2,5,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][72]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][72]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][72]={3,2,-1,1,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[158][72]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[159][72]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][72]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][72]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[162][72]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][72]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][72]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][72]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][72]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[167][72]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][72]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][72]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][72]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][72]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][73]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][73]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][73]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][73]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][73]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[5][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][73]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][73]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][73]={0,1,-1,4,{{0,-1},{0,-1},{1,4}},{30,1}}
 MapToConvert[9][73]={0,1,5,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[10][73]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][73]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{1,4}}
 MapToConvert[12][73]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][73]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][73]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][73]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][73]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[17][73]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[18][73]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][73]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][73]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][73]={0,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[23][73]={0,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[24][73]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[25][73]={0,2,2,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[26][73]={0,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][73]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{2,3}}
 MapToConvert[28][73]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[31][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][73]={0,2,-1,4,{{0,-1},{0,-1},{1,4}},{8,1}}
 MapToConvert[34][73]={0,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[35][73]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[36][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][73]={0,2,-1,4,{{0,-1},{1,3},{1,1}},{7,1}}
 MapToConvert[40][73]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][73]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[45][73]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[47][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][73]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][73]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][73]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][73]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][73]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[53][73]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][73]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[55][73]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][73]={0,2,5,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[57][73]={0,2,5,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][73]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][73]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][73]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][73]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{1,5}}
 MapToConvert[62][73]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][73]={0,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][73]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][73]={1,2,-1,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[66][73]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][73]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][73]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][73]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[70][73]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][73]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][73]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][73]={1,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][73]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{15,1}}
 MapToConvert[75][73]={1,1,5,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[76][73]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][73]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][73]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][73]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][73]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[81][73]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][73]={3,1,5,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[83][73]={3,1,-1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][73]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][73]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][73]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][73]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][73]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][73]={1,1,5,2,{{0,-1},{1,3},{0,-1}},{30,1}}
 MapToConvert[90][73]={1,2,5,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][73]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[92][73]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][73]={3,2,5,2,{{0,-1},{1,0},{1,1}},{33,1}}
 MapToConvert[94][73]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][73]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][73]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][73]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][73]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][73]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][73]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[101][73]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][73]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][73]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[104][73]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][73]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][73]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][73]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][73]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][73]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][73]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][73]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][73]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][73]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][73]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][73]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][73]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][73]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][73]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][73]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][73]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][73]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][73]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][73]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][73]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][73]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][73]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][73]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][73]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][73]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][73]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[131][73]={3,2,5,1,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[132][73]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][73]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][73]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][73]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][73]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][73]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[138][73]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[139][73]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][73]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][73]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[142][73]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][73]={3,2,5,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][73]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][73]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][73]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][73]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][73]={0,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][73]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][73]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][73]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][73]={3,2,-1,1,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[153][73]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][73]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[155][73]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][73]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][73]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[158][73]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][73]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][73]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][73]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][73]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][73]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][73]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[165][73]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{0,4}}
 MapToConvert[166][73]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[167][73]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][73]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][73]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][73]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][73]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][73]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][73]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][73]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][73]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][73]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][73]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][73]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][73]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][74]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][74]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][74]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[3][74]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][74]={0,1,-1,4,{{1,5},{1,3},{1,4}},{30,1}}
 MapToConvert[5][74]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][74]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][74]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][74]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][74]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{0,4}}
 MapToConvert[10][74]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[12][74]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][74]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][74]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[15][74]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][74]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][74]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[21][74]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][74]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][74]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][74]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][74]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][74]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{15,1}}
 MapToConvert[29][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[30][74]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][74]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[33][74]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][74]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][74]={0,2,-1,4,{{0,-1},{1,3},{1,4}},{2,5}}
 MapToConvert[41][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][74]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[49][74]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][74]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[51][74]={0,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][74]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{2,4}}
 MapToConvert[53][74]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][74]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][74]={0,2,5,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[56][74]={0,2,5,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[57][74]={0,2,5,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][74]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][74]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][74]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][74]={0,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][74]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][74]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[64][74]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][74]={1,2,-1,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[66][74]={1,2,-1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][74]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{2,3}}
 MapToConvert[68][74]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][74]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][74]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[71][74]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][74]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][74]={1,1,-1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][74]={1,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][74]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[79][74]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][74]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][74]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{0,4}}
 MapToConvert[82][74]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][74]={3,1,-1,2,{{0,-1},{1,0},{1,1}},{17,1}}
 MapToConvert[84][74]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][74]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][74]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][74]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][74]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][74]={1,2,5,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[90][74]={1,2,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][74]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][74]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][74]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][74]={3,2,5,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[95][74]={1,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][74]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[98][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][74]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][74]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][74]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{5,5}}
 MapToConvert[107][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][74]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][74]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][74]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][74]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][74]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][74]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][74]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][74]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][74]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][74]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][74]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][74]={1,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][74]={3,2,5,1,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[132][74]={3,0,-1,1,{{1,2},{1,0},{0,-1}},{-1,0}}
 MapToConvert[133][74]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][74]={1,1,-1,1,{{0,-1},{0,-1},{0,-1}},{2,4}}
 MapToConvert[135][74]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][74]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[137][74]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][74]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][74]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[141][74]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][74]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][74]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][74]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[146][74]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[147][74]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][74]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[149][74]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][74]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][74]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][74]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][74]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][74]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][74]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][74]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][74]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][74]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][74]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{0,4}}
 MapToConvert[160][74]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][74]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][74]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][74]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][74]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][74]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][74]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][74]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][74]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][74]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][74]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][74]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][74]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][74]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][74]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][74]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][74]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][75]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][75]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][75]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][75]={0,2,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[5][75]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[6][75]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[7][75]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][75]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][75]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][75]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{2,4}}
 MapToConvert[11][75]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][75]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][75]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][75]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][75]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][75]={0,2,2,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[20][75]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[21][75]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][75]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][75]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][75]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[25][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][75]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][75]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][75]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][75]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][75]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][75]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][75]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][75]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[34][75]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][75]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][75]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[37][75]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][75]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[39][75]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[40][75]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][75]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][75]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{5,4}}
 MapToConvert[43][75]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][75]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[45][75]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][75]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][75]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][75]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][75]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][75]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][75]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[52][75]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{0,4}}
 MapToConvert[53][75]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][75]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][75]={1,2,5,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[56][75]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][75]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][75]={1,2,-1,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[59][75]={1,2,5,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[60][75]={1,2,5,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[61][75]={1,2,5,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[62][75]={1,2,5,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[63][75]={1,2,5,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[64][75]={1,2,5,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[65][75]={1,2,5,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][75]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][75]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][75]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][75]={1,2,-1,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[70][75]={1,2,-1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][75]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][75]={1,1,-1,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[73][75]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[74][75]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][75]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][75]={3,0,-1,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[79][75]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[80][75]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][75]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][75]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][75]={3,1,-1,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[84][75]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][75]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][75]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][75]={1,1,-1,2,{{0,-1},{1,3},{0,-1}},{15,1}}
 MapToConvert[88][75]={1,2,-1,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[89][75]={1,2,-1,2,{{1,2},{0,-1},{0,-1}},{1,6}}
 MapToConvert[90][75]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][75]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][75]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][75]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][75]={1,2,-1,2,{{0,-1},{0,-1},{1,1}},{6,1}}
 MapToConvert[95][75]={1,2,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][75]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][75]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[101][75]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][75]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][75]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][75]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][75]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][75]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][75]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][75]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][75]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][75]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][75]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][75]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][75]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][75]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][75]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][75]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{0,4}}
 MapToConvert[130][75]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][75]={3,2,-1,1,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[132][75]={3,0,-1,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][75]={1,2,5,1,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[134][75]={1,2,5,1,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[135][75]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][75]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[137][75]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][75]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][75]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][75]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][75]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][75]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][75]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[145][75]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][75]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[147][75]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][75]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][75]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][75]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][75]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][75]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[154][75]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][75]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][75]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][75]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{15,1}}
 MapToConvert[158][75]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][75]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{4,3}}
 MapToConvert[160][75]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][75]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][75]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][75]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][75]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][75]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][75]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][75]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][75]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][75]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][75]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][75]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][75]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][75]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][75]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][75]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][75]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][75]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][76]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][76]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][76]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][76]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][76]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][76]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][76]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][76]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[8][76]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][76]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][76]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][76]={0,2,-1,4,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[12][76]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][76]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][76]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][76]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][76]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][76]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][76]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[19][76]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][76]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][76]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][76]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[23][76]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][76]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][76]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][76]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][76]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[28][76]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][76]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][76]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[31][76]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][76]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][76]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][76]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][76]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{1,4}}
 MapToConvert[36][76]={0,2,-1,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[37][76]={0,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[38][76]={0,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[39][76]={0,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[40][76]={3,2,5,4,{{1,2},{0,-1},{0,-1}},{20,1}}
 MapToConvert[41][76]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][76]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][76]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][76]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][76]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][76]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][76]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[48][76]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][76]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][76]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][76]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][76]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][76]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][76]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[55][76]={1,2,5,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[56][76]={1,2,5,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[57][76]={1,2,5,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[58][76]={1,2,5,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[59][76]={1,2,5,2,{{1,5},{0,-1},{0,-1}},{33,1}}
 MapToConvert[60][76]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][76]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][76]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][76]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][76]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][76]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[66][76]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[67][76]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][76]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][76]={1,2,5,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[70][76]={1,2,5,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][76]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][76]={1,2,-1,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[73][76]={1,2,-1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][76]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][76]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[76][76]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][76]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][76]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[79][76]={3,1,5,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[80][76]={1,2,5,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[81][76]={1,2,5,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[82][76]={1,2,5,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[83][76]={1,1,5,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[84][76]={1,1,5,2,{{1,2},{0,-1},{1,1}},{2,4}}
 MapToConvert[85][76]={1,1,5,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[86][76]={1,2,5,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[87][76]={1,2,5,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[88][76]={1,2,-1,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][76]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][76]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][76]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][76]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[93][76]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][76]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][76]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][76]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][76]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][76]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][76]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][76]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][76]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][76]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][76]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[104][76]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][76]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][76]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][76]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][76]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][76]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][76]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][76]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][76]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][76]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][76]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][76]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][76]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][76]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][76]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][76]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][76]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][76]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][76]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][76]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][76]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[125][76]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][76]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][76]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][76]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][76]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][76]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[131][76]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][76]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][76]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][76]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[135][76]={3,2,5,1,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[136][76]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][76]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[138][76]={1,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][76]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[140][76]={1,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][76]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][76]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][76]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][76]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][76]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][76]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][76]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][76]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][76]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][76]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][76]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][76]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][76]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][76]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][76]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][76]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{40,1}}
 MapToConvert[157][76]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][76]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][76]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][76]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][76]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[162][76]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[163][76]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][76]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[165][76]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][76]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][76]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][76]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][76]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][76]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][76]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][76]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][76]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][76]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][76]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][76]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][76]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][76]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][76]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][77]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[6][77]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][77]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][77]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][77]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[10][77]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{2,4}}
 MapToConvert[11][77]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[12][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][77]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][77]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][77]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][77]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][77]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][77]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][77]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][77]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][77]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][77]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][77]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][77]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][77]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][77]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][77]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][77]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][77]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{4,5}}
 MapToConvert[33][77]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][77]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][77]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][77]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][77]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][77]={3,2,5,4,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[40][77]={3,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[41][77]={3,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[42][77]={3,2,5,4,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[43][77]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[44][77]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][77]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][77]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][77]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[48][77]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{40,1}}
 MapToConvert[49][77]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][77]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[51][77]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][77]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][77]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][77]={1,2,5,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[55][77]={1,2,5,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][77]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][77]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[58][77]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][77]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][77]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][77]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][77]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][77]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][77]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][77]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][77]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][77]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][77]={1,2,5,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[69][77]={1,2,5,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][77]={1,2,5,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[71][77]={1,2,5,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[72][77]={3,2,-1,2,{{1,5},{0,-1},{0,-1}},{2,3}}
 MapToConvert[73][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][77]={3,2,-1,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[75][77]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][77]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][77]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][77]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][77]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][77]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][77]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[82][77]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][77]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][77]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][77]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][77]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[87][77]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][77]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][77]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][77]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[91][77]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][77]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][77]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[98][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][77]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[102][77]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][77]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][77]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][77]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,2}}
 MapToConvert[123][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][77]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][77]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][77]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][77]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][77]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][77]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][77]={3,0,-1,1,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[132][77]={3,2,-1,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[133][77]={3,2,5,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[134][77]={3,2,5,1,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[135][77]={1,2,5,1,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[136][77]={1,2,-1,1,{{0,-1},{1,3},{0,-1}},{5,4}}
 MapToConvert[137][77]={1,2,5,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[138][77]={1,2,5,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[139][77]={1,2,5,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[140][77]={3,2,-1,1,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][77]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{15,1}}
 MapToConvert[142][77]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][77]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][77]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][77]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][77]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][77]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][77]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[152][77]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][77]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][77]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{2,3}}
 MapToConvert[155][77]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][77]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][77]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][77]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][77]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][77]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][77]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][77]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][77]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][77]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][77]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][78]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][78]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][78]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][78]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][78]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][78]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][78]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][78]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][78]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][78]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][78]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][78]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][78]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][78]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][78]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][78]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][78]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][78]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][78]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[23][78]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][78]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[25][78]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][78]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][78]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][78]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][78]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][78]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][78]={0,2,-1,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[32][78]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][78]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][78]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][78]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[36][78]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][78]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][78]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[39][78]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][78]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][78]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][78]={3,2,5,4,{{0,-1},{1,0},{0,-1}},{9,1}}
 MapToConvert[43][78]={3,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][78]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][78]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][78]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][78]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][78]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][78]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][78]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][78]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][78]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][78]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][78]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][78]={1,2,5,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[56][78]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][78]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[58][78]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][78]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][78]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][78]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][78]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[63][78]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][78]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][78]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][78]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][78]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][78]={1,2,-1,2,{{0,-1},{1,0},{0,-1}},{6,1}}
 MapToConvert[69][78]={1,2,5,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[70][78]={1,2,5,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[71][78]={3,2,5,2,{{1,5},{0,-1},{0,-1}},{20,1}}
 MapToConvert[72][78]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][78]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][78]={3,2,-1,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[75][78]={1,2,5,2,{{1,5},{0,-1},{0,-1}},{20,1}}
 MapToConvert[76][78]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][78]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{4,3}}
 MapToConvert[78][78]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][78]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][78]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][78]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][78]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][78]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][78]={3,2,5,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[85][78]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][78]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][78]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][78]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][78]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][78]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][78]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][78]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{4,1}}
 MapToConvert[93][78]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][78]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][78]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][78]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][78]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][78]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][78]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][78]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][78]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][78]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][78]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][78]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][78]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[106][78]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][78]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][78]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][78]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][78]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][78]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][78]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{0,4}}
 MapToConvert[117][78]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][78]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[119][78]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][78]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][78]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][78]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][78]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][78]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][78]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][78]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][78]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][78]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][78]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[130][78]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][78]={3,0,-1,1,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[132][78]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][78]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][78]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][78]={3,2,5,1,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[136][78]={3,2,5,1,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[137][78]={3,2,5,1,{{1,2},{0,-1},{0,-1}},{40,1}}
 MapToConvert[138][78]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][78]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][78]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{0,5}}
 MapToConvert[141][78]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][78]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][78]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[144][78]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][78]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][78]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][78]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][78]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][78]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][78]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][78]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][78]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][78]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][78]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][78]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][78]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][78]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[158][78]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][78]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][78]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][78]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][78]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][78]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][78]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][78]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][78]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][78]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][78]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][79]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][79]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][79]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][79]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][79]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][79]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][79]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][79]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[8][79]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[9][79]={0,2,-1,4,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[10][79]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][79]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{3,2}}
 MapToConvert[12][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][79]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][79]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][79]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][79]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[18][79]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[19][79]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][79]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][79]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][79]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][79]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{1,4}}
 MapToConvert[24][79]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][79]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][79]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][79]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][79]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][79]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][79]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{0,4}}
 MapToConvert[31][79]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][79]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][79]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][79]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][79]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][79]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[37][79]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][79]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][79]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][79]={3,2,5,4,{{0,-1},{1,0},{0,-1}},{20,1}}
 MapToConvert[41][79]={3,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[42][79]={3,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][79]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][79]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][79]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][79]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][79]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][79]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][79]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][79]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[51][79]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][79]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][79]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{5,5}}
 MapToConvert[54][79]={1,2,-1,2,{{0,-1},{1,0},{0,-1}},{4,4}}
 MapToConvert[55][79]={1,2,5,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][79]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][79]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][79]={3,2,5,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[59][79]={3,2,5,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[60][79]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][79]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][79]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][79]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][79]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][79]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][79]={1,2,5,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[67][79]={1,2,5,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[68][79]={1,2,5,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][79]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][79]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][79]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][79]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][79]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][79]={3,2,5,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[75][79]={1,2,5,2,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[76][79]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][79]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[78][79]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][79]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][79]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][79]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][79]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][79]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[84][79]={1,2,5,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[85][79]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[86][79]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][79]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][79]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][79]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][79]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][79]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][79]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][79]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][79]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][79]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[96][79]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][79]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][79]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{2,5}}
 MapToConvert[99][79]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][79]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][79]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][79]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][79]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][79]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][79]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][79]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[114][79]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][79]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[120][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][79]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][79]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[125][79]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][79]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][79]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][79]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][79]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][79]={3,2,5,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[131][79]={3,2,5,1,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[132][79]={3,2,5,1,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[133][79]={3,2,5,1,{{1,5},{0,-1},{0,-1}},{9,1}}
 MapToConvert[134][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][79]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[136][79]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][79]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][79]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{4,4}}
 MapToConvert[140][79]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][79]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][79]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{3,2}}
 MapToConvert[143][79]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][79]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][79]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][79]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][79]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][79]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][79]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][79]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][79]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][79]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][79]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][79]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][79]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][79]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][79]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][79]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][79]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][79]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][79]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][79]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][79]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][79]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][79]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][80]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][80]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][80]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][80]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][80]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][80]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][80]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][80]={0,1,-1,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[9][80]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][80]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{1,2}}
 MapToConvert[11][80]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][80]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][80]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][80]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][80]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][80]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][80]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][80]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][80]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][80]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][80]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][80]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[25][80]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[26][80]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][80]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[28][80]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][80]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][80]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][80]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][80]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][80]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][80]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][80]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{40,1}}
 MapToConvert[36][80]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][80]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][80]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{40,1}}
 MapToConvert[39][80]={3,2,5,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[40][80]={3,2,5,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[41][80]={3,2,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][80]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][80]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][80]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][80]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][80]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[47][80]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][80]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][80]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[50][80]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][80]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{4,4}}
 MapToConvert[52][80]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][80]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][80]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][80]={1,2,5,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[56][80]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][80]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][80]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][80]={3,2,5,2,{{0,-1},{1,0},{1,1}},{20,1}}
 MapToConvert[60][80]={3,2,5,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][80]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][80]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[63][80]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][80]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[65][80]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][80]={1,2,5,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[67][80]={1,2,5,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[68][80]={3,2,5,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[69][80]={3,2,5,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[70][80]={3,1,5,2,{{1,5},{0,-1},{1,4}},{12,1}}
 MapToConvert[71][80]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][80]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][80]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{2,5}}
 MapToConvert[74][80]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[75][80]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][80]={1,2,5,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[77][80]={1,2,-1,2,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[78][80]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][80]={3,1,5,2,{{0,-1},{1,3},{0,-1}},{17,1}}
 MapToConvert[80][80]={1,1,5,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[81][80]={1,1,5,2,{{1,2},{1,0},{1,1}},{30,1}}
 MapToConvert[82][80]={1,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][80]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][80]={1,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][80]={1,2,5,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[86][80]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][80]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][80]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][80]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][80]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{5,5}}
 MapToConvert[91][80]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][80]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][80]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][80]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{40,1}}
 MapToConvert[95][80]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][80]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][80]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][80]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][80]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][80]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][80]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][80]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][80]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[109][80]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][80]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][80]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][80]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][80]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][80]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][80]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][80]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][80]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][80]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][80]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{0,4}}
 MapToConvert[128][80]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][80]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][80]={3,2,5,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[131][80]={3,2,5,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][80]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][80]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][80]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][80]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][80]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][80]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][80]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][80]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[140][80]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][80]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][80]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][80]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][80]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[149][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][80]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][80]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][80]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][80]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][80]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[164][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][80]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][80]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][80]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,2}}
 MapToConvert[170][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[172][80]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][80]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][80]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][80]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][80]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][80]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][80]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][80]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][81]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][81]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][81]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][81]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][81]={0,1,-1,4,{{0,-1},{1,0},{1,1}},{4,4}}
 MapToConvert[9][81]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][81]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][81]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][81]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][81]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][81]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[16][81]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][81]={0,1,-1,4,{{1,5},{0,-1},{1,4}},{2,4}}
 MapToConvert[18][81]={0,1,-1,4,{{1,5},{0,-1},{1,4}},{8,1}}
 MapToConvert[19][81]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[20][81]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{7,1}}
 MapToConvert[21][81]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[22][81]={0,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[23][81]={0,2,-1,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[24][81]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][81]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][81]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][81]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][81]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[29][81]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][81]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[31][81]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{1,3}}
 MapToConvert[32][81]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][81]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][81]={1,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][81]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][81]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][81]={3,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[38][81]={3,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[39][81]={3,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][81]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][81]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][81]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][81]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][81]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{40,1}}
 MapToConvert[45][81]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][81]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][81]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{40,1}}
 MapToConvert[48][81]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][81]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][81]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][81]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][81]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][81]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[54][81]={3,2,5,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[55][81]={3,2,5,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][81]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][81]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][81]={3,2,5,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[59][81]={3,2,-1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][81]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][81]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][81]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][81]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][81]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][81]={1,2,5,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[66][81]={1,2,5,2,{{1,5},{0,-1},{0,-1}},{20,1}}
 MapToConvert[67][81]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][81]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{0,2}}
 MapToConvert[69][81]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][81]={3,1,5,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[71][81]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][81]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][81]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][81]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][81]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][81]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][81]={1,2,5,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[78][81]={3,2,5,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[79][81]={3,2,5,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][81]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[81][81]={1,2,5,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[82][81]={1,2,5,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[83][81]={3,1,5,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[84][81]={1,2,5,2,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[85][81]={3,2,5,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[86][81]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][81]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][81]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[89][81]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][81]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][81]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][81]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][81]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][81]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][81]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][81]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][81]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][81]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][81]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][81]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{31,1}}
 MapToConvert[101][81]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][81]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][81]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][81]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][81]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][81]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][81]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][81]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[113][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][81]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][81]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][81]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][81]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{32,1}}
 MapToConvert[120][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][81]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[122][81]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][81]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][81]={3,0,-1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[125][81]={3,1,-1,1,{{1,5},{0,-1},{0,-1}},{12,1}}
 MapToConvert[126][81]={4,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][81]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][81]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[129][81]={3,2,5,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[130][81]={3,2,-1,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][81]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][81]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][81]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][81]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][81]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[137][81]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][81]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][81]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][81]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][81]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][81]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][81]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][81]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][81]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][81]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][81]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][81]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][81]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][81]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][81]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][81]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][81]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][81]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][81]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][81]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][81]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][81]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][81]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][81]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][82]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][82]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][82]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][82]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][82]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][82]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][82]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][82]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][82]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[9][82]={3,2,5,4,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[10][82]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][82]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][82]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][82]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][82]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][82]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][82]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][82]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][82]={3,1,5,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][82]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][82]={0,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][82]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][82]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][82]={0,2,5,4,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][82]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{33,1}}
 MapToConvert[25][82]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][82]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][82]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][82]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][82]={0,2,2,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][82]={1,2,-1,4,{{0,-1},{0,-1},{0,-1}},{6,1}}
 MapToConvert[31][82]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][82]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][82]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[34][82]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][82]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][82]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][82]={4,2,-1,4,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[38][82]={3,2,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][82]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][82]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[41][82]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][82]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][82]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[44][82]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][82]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][82]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[47][82]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][82]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][82]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][82]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][82]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][82]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{0,2}}
 MapToConvert[53][82]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][82]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][82]={3,2,5,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[56][82]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][82]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][82]={3,2,-1,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[59][82]={3,2,5,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][82]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{40,1}}
 MapToConvert[61][82]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][82]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{40,1}}
 MapToConvert[63][82]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][82]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][82]={3,2,5,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[66][82]={3,2,5,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][82]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][82]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][82]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][82]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[71][82]={3,2,5,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[72][82]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][82]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][82]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][82]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][82]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[77][82]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][82]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][82]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][82]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][82]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][82]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][82]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][82]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][82]={3,2,5,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[86][82]={3,2,5,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][82]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][82]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][82]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{17,1}}
 MapToConvert[90][82]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][82]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[92][82]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][82]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][82]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][82]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][82]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][82]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[98][82]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][82]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][82]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][82]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][82]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][82]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{40,1}}
 MapToConvert[104][82]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][82]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][82]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][82]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][82]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][82]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][82]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][82]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][82]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][82]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][82]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{40,1}}
 MapToConvert[115][82]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][82]={4,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][82]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][82]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{2,3}}
 MapToConvert[119][82]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][82]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][82]={3,1,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][82]={3,1,-1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[123][82]={3,0,-1,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][82]={3,1,-1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[125][82]={3,1,5,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][82]={3,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][82]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][82]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][82]={3,2,-1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[130][82]={3,2,5,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][82]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][82]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][82]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{3,1}}
 MapToConvert[134][82]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][82]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][82]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][82]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][82]={3,2,5,1,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[139][82]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][82]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][82]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][82]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][82]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][82]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][82]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][82]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][82]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][82]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][82]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][82]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][82]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][82]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][82]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][82]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][82]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][82]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][82]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][82]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[159][82]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][82]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][82]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][82]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][82]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][82]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][82]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][82]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][82]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][82]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][82]={4,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][82]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][82]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][82]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][82]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][82]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][82]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][82]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][82]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][82]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][82]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][83]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][83]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[2][83]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][83]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][83]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[5][83]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][83]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][83]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][83]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][83]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[10][83]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][83]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][83]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][83]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][83]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][83]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][83]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][83]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[18][83]={3,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[19][83]={3,1,5,4,{{1,5},{0,-1},{0,-1}},{16,1}}
 MapToConvert[20][83]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][83]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[22][83]={0,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][83]={0,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][83]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][83]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][83]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{11,1}}
 MapToConvert[27][83]={0,2,-1,4,{{0,-1},{0,-1},{0,-1}},{8,1}}
 MapToConvert[28][83]={0,2,2,4,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[29][83]={0,2,2,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[30][83]={3,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[31][83]={3,2,5,4,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[32][83]={3,2,5,4,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[33][83]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][83]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][83]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][83]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][83]={4,2,-1,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[38][83]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][83]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][83]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][83]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][83]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][83]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][83]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][83]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][83]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][83]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][83]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][83]={4,1,-1,4,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[50][83]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][83]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][83]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][83]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[54][83]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][83]={3,2,-1,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[56][83]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][83]={3,2,-1,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[58][83]={3,2,-1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][83]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][83]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][83]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][83]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][83]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][83]={3,2,5,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[65][83]={3,2,5,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[66][83]={3,1,5,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[67][83]={3,2,5,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[68][83]={3,2,5,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[69][83]={3,2,5,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[70][83]={3,2,5,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[71][83]={3,2,5,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][83]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][83]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{3,6}}
 MapToConvert[74][83]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][83]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][83]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][83]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][83]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][83]={3,2,5,2,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[80][83]={3,2,5,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[81][83]={3,2,5,2,{{1,2},{0,-1},{1,1}},{-1,0}}
 MapToConvert[82][83]={3,1,5,2,{{1,2},{0,-1},{1,1}},{4,4}}
 MapToConvert[83][83]={3,2,5,2,{{1,2},{1,0},{1,1}},{-1,0}}
 MapToConvert[84][83]={3,2,-1,2,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[85][83]={3,2,-1,2,{{1,5},{0,-1},{0,-1}},{20,1}}
 MapToConvert[86][83]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][83]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][83]={4,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][83]={4,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][83]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][83]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][83]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][83]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][83]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[95][83]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][83]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[97][83]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][83]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{16,1}}
 MapToConvert[99][83]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][83]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][83]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][83]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][83]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][83]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{4,3}}
 MapToConvert[105][83]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][83]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[107][83]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][83]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][83]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][83]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][83]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][83]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{3,4}}
 MapToConvert[113][83]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][83]={3,2,-1,1,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[115][83]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][83]={4,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][83]={4,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][83]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][83]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][83]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][83]={3,0,-1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[122][83]={3,1,-1,1,{{1,5},{1,0},{0,-1}},{2,4}}
 MapToConvert[123][83]={3,1,-1,1,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[124][83]={3,1,5,1,{{1,5},{0,-1},{1,4}},{15,1}}
 MapToConvert[125][83]={3,0,-1,1,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[126][83]={3,2,-1,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][83]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][83]={3,2,5,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[129][83]={3,2,5,1,{{1,5},{0,-1},{0,-1}},{40,1}}
 MapToConvert[130][83]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][83]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][83]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][83]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][83]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][83]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][83]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][83]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][83]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][83]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][83]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][83]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][83]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][83]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][83]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][83]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][83]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][83]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][83]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][83]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][83]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][83]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][83]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][83]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][83]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][83]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][83]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][83]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][83]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][83]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][83]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][83]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][83]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][83]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][83]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][83]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][83]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][83]={4,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][83]={4,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][83]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][83]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][83]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][83]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][83]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][83]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][83]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][83]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][83]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][83]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][83]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][84]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][84]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][84]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[3][84]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][84]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{5,4}}
 MapToConvert[5][84]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][84]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][84]={6,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][84]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][84]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][84]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][84]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][84]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][84]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][84]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][84]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][84]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][84]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][84]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][84]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][84]={3,1,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[21][84]={3,1,-1,4,{{0,-1},{1,0},{0,-1}},{0,5}}
 MapToConvert[22][84]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][84]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][84]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[25][84]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][84]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][84]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][84]={3,2,-1,4,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[29][84]={3,2,5,4,{{1,5},{0,-1},{1,4}},{20,1}}
 MapToConvert[30][84]={3,2,-1,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[31][84]={3,2,5,4,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[32][84]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[33][84]={3,2,-1,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[34][84]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][84]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][84]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][84]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][84]={4,2,-1,4,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[39][84]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][84]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][84]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][84]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][84]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][84]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][84]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][84]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][84]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][84]={4,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][84]={4,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][84]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][84]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][84]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][84]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][84]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][84]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][84]={3,2,-1,2,{{0,-1},{0,-1},{1,1}},{-1,0}}
 MapToConvert[57][84]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][84]={3,2,-1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][84]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][84]={4,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][84]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][84]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][84]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][84]={3,2,-1,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[65][84]={3,2,-1,2,{{1,5},{0,-1},{0,-1}},{20,1}}
 MapToConvert[66][84]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][84]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][84]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{0,4}}
 MapToConvert[69][84]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][84]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][84]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[72][84]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][84]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][84]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{40,1}}
 MapToConvert[75][84]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][84]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][84]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][84]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[79][84]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][84]={3,2,5,2,{{1,2},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][84]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{40,1}}
 MapToConvert[82][84]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][84]={3,1,5,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[84][84]={3,2,-1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][84]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][84]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][84]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{0,4}}
 MapToConvert[88][84]={3,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][84]={4,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][84]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][84]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][84]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][84]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][84]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][84]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][84]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][84]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][84]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][84]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][84]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[101][84]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][84]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][84]={4,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][84]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][84]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][84]={4,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][84]={4,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][84]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][84]={4,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][84]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][84]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][84]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][84]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][84]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][84]={3,2,-1,1,{{0,-1},{0,-1},{1,4}},{3,3}}
 MapToConvert[116][84]={3,2,-1,1,{{1,5},{0,-1},{1,4}},{4,2}}
 MapToConvert[117][84]={3,0,-1,1,{{1,5},{1,3},{1,4}},{-1,0}}
 MapToConvert[118][84]={3,2,5,1,{{1,5},{0,-1},{1,4}},{20,1}}
 MapToConvert[119][84]={3,2,5,1,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[120][84]={3,2,5,1,{{1,5},{0,-1},{1,4}},{9,1}}
 MapToConvert[121][84]={3,2,-1,1,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[122][84]={3,2,-1,1,{{1,5},{0,-1},{1,4}},{20,1}}
 MapToConvert[123][84]={3,0,-1,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][84]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][84]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][84]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{3,3}}
 MapToConvert[127][84]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][84]={3,2,-1,1,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[129][84]={3,2,-1,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][84]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][84]={3,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][84]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][84]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][84]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][84]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][84]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][84]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][84]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][84]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][84]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][84]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][84]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][84]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][84]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][84]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][84]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][84]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][84]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][84]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][84]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][84]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][84]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][84]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][84]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][84]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][84]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][84]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][84]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][84]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][84]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][84]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][84]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][84]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][84]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][84]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][84]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][84]={4,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][84]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][84]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][84]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][84]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][84]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][84]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[174][84]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][84]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][84]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][84]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][84]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][84]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][85]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][85]={4,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][85]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][85]={4,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][85]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][85]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][85]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][85]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][85]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][85]={5,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][85]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][85]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][85]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][85]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][85]={3,1,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][85]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][85]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][85]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][85]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{9,1}}
 MapToConvert[26][85]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][85]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][85]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][85]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][85]={3,2,5,4,{{0,-1},{1,3},{1,4}},{-1,0}}
 MapToConvert[31][85]={3,2,-1,4,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[32][85]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{0,3}}
 MapToConvert[33][85]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][85]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][85]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][85]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][85]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][85]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][85]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][85]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][85]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][85]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][85]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][85]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][85]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][85]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][85]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][85]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][85]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][85]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][85]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][85]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][85]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][85]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][85]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][85]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][85]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][85]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][85]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][85]={4,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][85]={4,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][85]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][85]={3,2,-1,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[64][85]={3,2,-1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][85]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][85]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][85]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][85]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][85]={3,1,-1,2,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[70][85]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][85]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][85]={3,1,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][85]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][85]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][85]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][85]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][85]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][85]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][85]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][85]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][85]={3,2,5,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][85]={3,1,5,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[83][85]={3,2,-1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][85]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][85]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][85]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][85]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][85]={4,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][85]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][85]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][85]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][85]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][85]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][85]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][85]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][85]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][85]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][85]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][85]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][85]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][85]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][85]={4,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][85]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][85]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][85]={4,0,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][85]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][85]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][85]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][85]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][85]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][85]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][85]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][85]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][85]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][85]={4,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][85]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][85]={4,0,-1,1,{{0,-1},{0,-1},{1,4}},{-1,0}}
 MapToConvert[118][85]={4,0,-1,1,{{1,5},{0,-1},{1,4}},{-1,0}}
 MapToConvert[119][85]={3,0,-1,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][85]={3,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][85]={4,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][85]={4,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][85]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][85]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][85]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][85]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][85]={3,2,-1,1,{{0,-1},{1,0},{0,-1}},{20,1}}
 MapToConvert[128][85]={3,2,-1,1,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][85]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][85]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][85]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][85]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][85]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][85]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][85]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][85]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][85]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][85]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][85]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][85]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][85]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][85]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][85]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][85]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][85]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][85]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][85]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][85]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][85]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][85]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][85]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][85]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][85]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][85]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][85]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][85]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][85]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][85]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][85]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][85]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][85]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][85]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][85]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][85]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][85]={4,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][85]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][85]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][85]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][85]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][85]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][85]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][85]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][85]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][85]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][85]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][85]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[178][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][85]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][86]={4,1,-1,4,{{0,-1},{0,-1},{0,-1}},{3,5}}
 MapToConvert[2][86]={5,3,0,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][86]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[21][86]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][86]={3,1,-1,4,{{1,5},{0,-1},{1,4}},{4,4}}
 MapToConvert[23][86]={3,0,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][86]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{30,1}}
 MapToConvert[25][86]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[26][86]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[27][86]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][86]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[29][86]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][86]={3,2,5,4,{{1,2},{1,0},{1,1}},{20,1}}
 MapToConvert[31][86]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][86]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][86]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[34][86]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][86]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][86]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][86]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][86]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][86]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][86]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][86]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][86]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][86]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][86]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][86]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][86]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][86]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][86]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][86]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][86]={3,2,-1,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[64][86]={3,2,-1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][86]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][86]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[83][86]={3,2,-1,2,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[84][86]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][86]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][86]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][86]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][86]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][86]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][86]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][86]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][86]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][86]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[115][86]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][86]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][86]={4,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][86]={4,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][86]={4,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][86]={4,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][86]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][86]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][86]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][86]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][86]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][86]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][86]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][86]={4,2,-1,1,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[129][86]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][86]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][86]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][86]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][86]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][86]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][86]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][86]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][86]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][86]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][86]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][86]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][86]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][86]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][86]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][86]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][86]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][86]={4,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][86]={4,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][86]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][86]={4,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][86]={4,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][86]={4,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][86]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][86]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][86]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][86]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][86]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][86]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173][86]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[174][86]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[175][86]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[176][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[177][86]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[178][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[179][86]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[0][87]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[1][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[2][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[3][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[4][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[5][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[6][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[7][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[8][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[9][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[10][87]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[11][87]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[12][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[13][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[14][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[15][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[16][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[17][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[18][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[19][87]={6,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[20][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{13,1}}
 MapToConvert[21][87]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[22][87]={3,1,-1,4,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[23][87]={3,1,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[24][87]={3,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[25][87]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{20,1}}
 MapToConvert[26][87]={3,2,5,4,{{0,-1},{1,3},{0,-1}},{-1,0}}
 MapToConvert[27][87]={3,2,5,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[28][87]={3,2,5,4,{{0,-1},{1,0},{0,-1}},{9,1}}
 MapToConvert[29][87]={3,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[30][87]={3,1,5,4,{{0,-1},{1,0},{1,1}},{-1,0}}
 MapToConvert[31][87]={4,1,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[32][87]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[33][87]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{12,1}}
 MapToConvert[34][87]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[35][87]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[36][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[37][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[38][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[39][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[40][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[41][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[42][87]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[43][87]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[44][87]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[45][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[46][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[47][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[48][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[49][87]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[50][87]={4,2,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[51][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[52][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[53][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[54][87]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[55][87]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[56][87]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[57][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[58][87]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[59][87]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[60][87]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[61][87]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[62][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[63][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[64][87]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[65][87]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[66][87]={4,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[67][87]={4,1,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[68][87]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[69][87]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[70][87]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[71][87]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[72][87]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[73][87]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[74][87]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[75][87]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[76][87]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[77][87]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[78][87]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[79][87]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[80][87]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[81][87]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[82][87]={3,2,-1,2,{{0,-1},{1,0},{0,-1}},{-1,0}}
 MapToConvert[83][87]={3,2,-1,2,{{1,5},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[84][87]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[85][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[86][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[87][87]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[88][87]={3,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[89][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[90][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[91][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[92][87]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[93][87]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[94][87]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[95][87]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[96][87]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[97][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[98][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[99][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[100][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[101][87]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[102][87]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[103][87]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[104][87]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[105][87]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[106][87]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[107][87]={4,2,-1,2,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[108][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[109][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[110][87]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[111][87]={6,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[112][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[113][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[114][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[115][87]={5,3,-1,0,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[116][87]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[117][87]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[118][87]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[119][87]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[120][87]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[121][87]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[122][87]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[123][87]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[124][87]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[125][87]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[126][87]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[127][87]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[128][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[129][87]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[130][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[131][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[132][87]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[133][87]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[134][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[135][87]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[136][87]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[137][87]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[138][87]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[139][87]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[140][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[141][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[142][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[143][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[144][87]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[145][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[146][87]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[147][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[148][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[149][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[150][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[151][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[152][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[153][87]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[154][87]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[155][87]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[156][87]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[157][87]={4,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[158][87]={5,3,0,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[159][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[160][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[161][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[162][87]={5,3,-1,4,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[163][87]={4,0,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[164][87]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[165][87]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[166][87]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[167][87]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[168][87]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[169][87]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[170][87]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[171][87]={4,1,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[172][87]={4,2,-1,1,{{0,-1},{0,-1},{0,-1}},{-1,0}}
 MapToConvert[173]